<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.66
Name: EXNDS Patient Blutgruppe Entry
Description: Codierte bzw. strukturierte Angabe der Blutgruppe nach AB0 System
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019">
   <title>EXNDS Patient Blutgruppe Entry</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]"
         id="d45e23777-false-d1100490e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@classCode) = ('OBS')">(EXNDS Patient Blutgruppe Entry): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Patient Blutgruppe Entry): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']) &gt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']) &lt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:code[(@code = '365637002' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:code[(@code = '365637002' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:code[(@code = '365637002' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:code[(@code = '365637002' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Patient Blutgruppe Entry): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']"
         id="d45e23780-false-d1100546e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Blutgruppe Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.66')">(EXNDS Patient Blutgruppe Entry): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.66' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:id
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:id"
         id="d45e23782-false-d1100560e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Blutgruppe Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:code[(@code = '365637002' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:code[(@code = '365637002' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d45e23783-false-d1100571e0">
      <extends rule="CD.SDTC"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Blutgruppe Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@code) = ('365637002')">(EXNDS Patient Blutgruppe Entry): Der Wert von code MUSS '365637002' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(EXNDS Patient Blutgruppe Entry): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.96' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@displayName) = ('Finding of AB0 blood group') or not(@displayName)">(EXNDS Patient Blutgruppe Entry): Der Wert von displayName MUSS 'Finding of AB0 blood group' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Patient Blutgruppe Entry): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(EXNDS Patient Blutgruppe Entry): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Patient Blutgruppe Entry): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:text
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:text"
         id="d45e23788-false-d1100602e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Patient Blutgruppe Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.66
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Patient Blutgruppe Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.66']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d45e23789-false-d1100615e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Blutgruppe Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.66-2020-03-08T145019.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.34-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Patient Blutgruppe Entry): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.34 exnds_BlutgruppeAB0_VS (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
