<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.139
Name: EXNDS Preis Arzneimittel
Description: Template CDA Act (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715">
   <title>EXNDS Preis Arzneimittel</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]
Item: (EXNDS Preis Arzneimittel)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]
Item: (EXNDS Preis Arzneimittel)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]"
         id="d45e16522-false-d600725e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@classCode) = ('ACT')">(EXNDS Preis Arzneimittel): Der Wert von classCode MUSS 'ACT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Preis Arzneimittel): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Preis Arzneimittel): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']) &gt;= 1">(EXNDS Preis Arzneimittel): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']) &lt;= 1">(EXNDS Preis Arzneimittel): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:code[(@code = 'ArzMittelPreis' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Preis Arzneimittel): Element hl7:code[(@code = 'ArzMittelPreis' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:code[(@code = 'ArzMittelPreis' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Preis Arzneimittel): Element hl7:code[(@code = 'ArzMittelPreis' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:effectiveTime) &lt;= 1">(EXNDS Preis Arzneimittel): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']
Item: (EXNDS Preis Arzneimittel)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']"
         id="d45e16526-false-d601116e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Preis Arzneimittel): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.139')">(EXNDS Preis Arzneimittel): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.139' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:id
Item: (EXNDS Preis Arzneimittel)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:id"
         id="d45e16528-false-d601130e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Preis Arzneimittel): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:code[(@code = 'ArzMittelPreis' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Preis Arzneimittel)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:code[(@code = 'ArzMittelPreis' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d45e16529-false-d601141e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Preis Arzneimittel): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@code) = ('ArzMittelPreis')">(EXNDS Preis Arzneimittel): Der Wert von code MUSS 'ArzMittelPreis' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Preis Arzneimittel): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@displayName) = ('Arzneimittelpreis') or not(@displayName)">(EXNDS Preis Arzneimittel): Der Wert von displayName MUSS 'Arzneimittelpreis' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Preis Arzneimittel): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Preis Arzneimittel): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Preis Arzneimittel): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:effectiveTime
Item: (EXNDS Preis Arzneimittel)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:effectiveTime"
         id="d45e16534-false-d601172e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Preis Arzneimittel): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]
Item: (EXNDS Preis Arzneimittel)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]">
      <extends rule="d601588e0-false-d601592e0"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="@typeCode">(EXNDS Preis Arzneimittel): Attribut @typeCode MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19447-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(EXNDS Preis Arzneimittel): Der Wert von typeCode MUSS gewählt werden aus Value Set '2.16.840.1.113883.1.11.19447' x_ActRelationshipEntryRelationship (DYNAMIC).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@contextConductionInd) or string(@contextConductionInd)=('true','false')">(EXNDS Preis Arzneimittel): Attribute @contextConductionInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@contextConductionInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@inversionInd) or string(@inversionInd)=('true','false')">(EXNDS Preis Arzneimittel): Attribute @inversionInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@inversionInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Preis Arzneimittel): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(EXNDS Preis Arzneimittel): Element hl7:sequenceNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="count(hl7:seperatableInd) &lt;= 1">(EXNDS Preis Arzneimittel): Element hl7:seperatableInd kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]/hl7:sequenceNumber
Item: (EXNDS Preis Arzneimittel)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]/hl7:sequenceNumber">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(EXNDS Preis Arzneimittel): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Preis Arzneimittel): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.139
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]/hl7:seperatableInd
Item: (EXNDS Preis Arzneimittel)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]/hl7:seperatableInd">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.139-2020-10-06T154715.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(EXNDS Preis Arzneimittel): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.300
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.139']]/hl7:entryRelationship[@typeCode]
Item: (CDA Clinical Statement)
-->
   <rule fpi="RULC-1" id="d601588e0-false-d601592e0" abstract="true">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.300-2005-09-07T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']] | hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']] | hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']] | hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']] | hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']] | hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']] | hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']] | hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) &gt;= 1">(CDA Clinical Statement): Auswahl (hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']]  oder  hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]  oder  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]  oder  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']]  oder  hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']]  oder  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']]  oder  hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']]  oder  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']]  oder  hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.300-2005-09-07T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']] | hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']] | hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']] | hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']] | hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']] | hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']] | hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']] | hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) &lt;= 1">(CDA Clinical Statement): Auswahl (hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']]  oder  hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]  oder  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]  oder  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']]  oder  hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']]  oder  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']]  oder  hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']]  oder  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']]  oder  hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) enthält zu viele Elemente [max 1x]</assert>
   </rule>
</pattern>
