<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.137
Name: EXNDS Karteieintragungen Organizer
Description: Organizer-Element zur Gruppierung mehrerer Karteineintragungen
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259">
   <title>EXNDS Karteieintragungen Organizer</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]
Item: (EXNDS Karteieintragungen Organizer)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]
Item: (EXNDS Karteieintragungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]"
         id="d45e16423-false-d583166e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@classCode) = ('BATTERY')">(EXNDS Karteieintragungen Organizer): Der Wert von classCode MUSS 'BATTERY' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Karteieintragungen Organizer): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']) &gt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']) &lt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:code[(@code = 'Karteieintragungen' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:code[(@code = 'Karteieintragungen' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:code[(@code = 'Karteieintragungen' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:code[(@code = 'Karteieintragungen' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:statusCode[@code = 'completed' or @nullFlavor] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:statusCode[@code = 'completed' or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:effectiveTime) &lt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.136']]]) &gt;= 1">(EXNDS Karteieintragungen Organizer): Element hl7:component[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.136']]] ist mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']
Item: (EXNDS Karteieintragungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']"
         id="d45e16426-false-d583230e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Karteieintragungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.137')">(EXNDS Karteieintragungen Organizer): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.137' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:id
Item: (EXNDS Karteieintragungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:id"
         id="d45e16428-false-d583244e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Karteieintragungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:code[(@code = 'Karteieintragungen' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Karteieintragungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:code[(@code = 'Karteieintragungen' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d45e16429-false-d583255e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Karteieintragungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@code) = ('Karteieintragungen')">(EXNDS Karteieintragungen Organizer): Der Wert von code MUSS 'Karteieintragungen' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Karteieintragungen Organizer): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@displayName) = ('Karteieintragungen') or not(@displayName)">(EXNDS Karteieintragungen Organizer): Der Wert von displayName MUSS 'Karteieintragungen' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Karteieintragungen Organizer): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Karteieintragungen Organizer): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Karteieintragungen Organizer): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (EXNDS Karteieintragungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d45e16434-false-d583287e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Karteieintragungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Karteieintragungen Organizer): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:effectiveTime
Item: (EXNDS Karteieintragungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:effectiveTime"
         id="d45e16436-false-d583303e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Karteieintragungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.137
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:component[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.136']]]
Item: (EXNDS Karteieintragungen Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]/hl7:component[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.136']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Karteieintragungen Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.137-2020-10-06T114259.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Karteieintragungen Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
