<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.135
Name: EXNDS Tarif Zusatzkennzeichen
Description: Angabe etwaiger Zusatzkennzeichen für einen Tarif
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220">
   <title>EXNDS Tarif Zusatzkennzeichen</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]"
         id="d45e16350-false-d582505e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@classCode) = ('OBS')">(EXNDS Tarif Zusatzkennzeichen): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Tarif Zusatzkennzeichen): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']) &gt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']) &lt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:code[(@code = 'Zusatzkennzeichen' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:code[(@code = 'Zusatzkennzeichen' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:code[(@code = 'Zusatzkennzeichen' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:code[(@code = 'Zusatzkennzeichen' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Tarif Zusatzkennzeichen): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:value[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:value[@nullFlavor='NA'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']"
         id="d45e16353-false-d582557e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Tarif Zusatzkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.135')">(EXNDS Tarif Zusatzkennzeichen): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.135' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:id
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:id"
         id="d45e16355-false-d582571e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Tarif Zusatzkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:code[(@code = 'Zusatzkennzeichen' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:code[(@code = 'Zusatzkennzeichen' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d45e16356-false-d582582e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Tarif Zusatzkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@code) = ('Zusatzkennzeichen')">(EXNDS Tarif Zusatzkennzeichen): Der Wert von code MUSS 'Zusatzkennzeichen' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Tarif Zusatzkennzeichen): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@displayName) = ('Zusatzkennzeichen') or not(@displayName)">(EXNDS Tarif Zusatzkennzeichen): Der Wert von displayName MUSS 'Zusatzkennzeichen' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Tarif Zusatzkennzeichen): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Tarif Zusatzkennzeichen): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Tarif Zusatzkennzeichen): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[not(@nullFlavor)]
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[not(@nullFlavor)]"
         id="d45e16362-false-d582611e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Tarif Zusatzkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="not(@nullFlavor)">(EXNDS Tarif Zusatzkennzeichen): Attribut @nullFlavor DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(EXNDS Tarif Zusatzkennzeichen): Attribute @nullFlavor MUSS vom Datentyp 'cs' sein  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.135
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[@nullFlavor='NA']
Item: (EXNDS Tarif Zusatzkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[@nullFlavor='NA']"
         id="d45e16366-false-d582625e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Tarif Zusatzkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="string(@nullFlavor) = ('NA')">(EXNDS Tarif Zusatzkennzeichen): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.135-2020-10-02T153220.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(EXNDS Tarif Zusatzkennzeichen): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[@nullFlavor='NA']/hl7:originalText
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[@nullFlavor='NA']/hl7:originalText"
         id="d582628e60-false-d582655e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d582628e66-false-d582674e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>
</pattern>
