<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.126
Name: EXNDS Kassenleistung
Description: Angabe ob die Leistung eine Kassenleistung darstellt als (wenn ja) Information über die leistungserbringenden Kasse.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210">
   <title>EXNDS Kassenleistung</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]
Item: (EXNDS Kassenleistung)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]"
         id="d45e15999-false-d574854e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@classCode) = ('OBS')">(EXNDS Kassenleistung): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Kassenleistung): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Kassenleistung): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']) &gt;= 1">(EXNDS Kassenleistung): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']) &lt;= 1">(EXNDS Kassenleistung): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:code[(@code = 'Kassenleistung' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Kassenleistung): Element hl7:code[(@code = 'Kassenleistung' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:code[(@code = 'Kassenleistung' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Kassenleistung): Element hl7:code[(@code = 'Kassenleistung' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(EXNDS Kassenleistung): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(EXNDS Kassenleistung): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &gt;= 1">(EXNDS Kassenleistung): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Kassenleistung): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(EXNDS Kassenleistung): Element hl7:value[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="count(hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Kassenleistung): Element hl7:value[@nullFlavor='NA'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']"
         id="d45e16003-false-d574921e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Kassenleistung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.126')">(EXNDS Kassenleistung): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.126' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:id
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:id"
         id="d45e16005-false-d574935e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Kassenleistung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:code[(@code = 'Kassenleistung' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:code[(@code = 'Kassenleistung' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d45e16006-false-d574946e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Kassenleistung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@code) = ('Kassenleistung')">(EXNDS Kassenleistung): Der Wert von code MUSS 'Kassenleistung' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Kassenleistung): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@displayName) = ('Kassenleistung') or not(@displayName)">(EXNDS Kassenleistung): Der Wert von displayName MUSS 'Kassenleistung' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Kassenleistung): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Kassenleistung): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Kassenleistung): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:statusCode[@code = 'completed']
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:statusCode[@code = 'completed']"
         id="d45e16011-false-d574978e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Kassenleistung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Kassenleistung): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:value[not(@nullFlavor)]
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:value[not(@nullFlavor)]"
         id="d45e16014-false-d574992e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Kassenleistung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Kassenleistung): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.39 exnds_Versicherungsträger_VS (DYNAMIC)' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="not(@nullFlavor)">(EXNDS Kassenleistung): Attribut @nullFlavor DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(EXNDS Kassenleistung): Attribute @nullFlavor MUSS vom Datentyp 'cs' sein  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.126
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:value[@nullFlavor='NA']
Item: (EXNDS Kassenleistung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.126']]/hl7:value[@nullFlavor='NA']"
         id="d45e16017-false-d575015e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Kassenleistung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.126-2020-10-02T133210.html"
              test="string(@nullFlavor) = ('NA')">(EXNDS Kassenleistung): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
</pattern>
