<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.120
Name: EXNDS Versicherungstraeger
Description: Kodierte Angabe des Versicherungsträgers. Codes auf Basis der DVP-Codes
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350">
   <title>EXNDS Versicherungstraeger</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]
Item: (EXNDS Versicherungstraeger)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]"
         id="d45e15748-false-d572637e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@classCode) = ('OBS')">(EXNDS Versicherungstraeger): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Versicherungstraeger): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Versicherungstraeger): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']) &gt;= 1">(EXNDS Versicherungstraeger): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']) &lt;= 1">(EXNDS Versicherungstraeger): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:code[(@code = 'VSTRL' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Versicherungstraeger): Element hl7:code[(@code = 'VSTRL' and @codeSystem = '1.2.40.0.34.5.195')] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:code[(@code = 'VSTRL' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Versicherungstraeger): Element hl7:code[(@code = 'VSTRL' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Versicherungstraeger): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(EXNDS Versicherungstraeger): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(EXNDS Versicherungstraeger): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(EXNDS Versicherungstraeger): Element hl7:effectiveTime[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(EXNDS Versicherungstraeger): Element hl7:effectiveTime[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Versicherungstraeger): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Versicherungstraeger): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']"
         id="d45e15752-false-d572714e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.120')">(EXNDS Versicherungstraeger): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.120' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:id
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:id"
         id="d45e15754-false-d572728e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:code[(@code = 'VSTRL' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:code[(@code = 'VSTRL' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d45e15755-false-d572739e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@code) = ('VSTRL')">(EXNDS Versicherungstraeger): Der Wert von code MUSS 'VSTRL' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Versicherungstraeger): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@displayName) = ('Leistungszuständiger Versicherungsträger') or not(@displayName)">(EXNDS Versicherungstraeger): Der Wert von displayName MUSS 'Leistungszuständiger Versicherungsträger' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Versicherungstraeger): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Versicherungstraeger): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Versicherungstraeger): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:text
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:text"
         id="d45e15760-false-d572773e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:text/hl7:text
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:text/hl7:text"
         id="d572769e91-false-d572794e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:text/hl7:text/hl7:reference[not(@nullFlavor)]
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:text/hl7:text/hl7:reference[not(@nullFlavor)]"
         id="d572769e93-false-d572813e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="@value">(Narrative Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="starts-with(@value,'#') or starts-with(@value,'http')">(Narrative Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element, or begin with the 'http' or 'https' url-scheme.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:statusCode[@code = 'completed']
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:statusCode[@code = 'completed']"
         id="d45e15764-false-d572828e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Versicherungstraeger): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d45e15766-false-d572844e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.120
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Versicherungstraeger)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.120']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d45e15767-false-d572857e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Versicherungstraeger): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.120-2020-10-02T104350.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.39-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Versicherungstraeger): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.39 exnds_Versicherungsträger_VS (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
