<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.117
Name: EXNDS Behandlungsschein Act
Description: Strukturierte und Kodierte Angabe zu einem Behandlungsschein
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233">
   <title>EXNDS Behandlungsschein Act</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]
Item: (EXNDS Behandlungsschein Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]
Item: (EXNDS Behandlungsschein Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]"
         id="d45e15621-false-d570424e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@classCode) = ('ACT')">(EXNDS Behandlungsschein Act): Der Wert von classCode MUSS 'ACT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Behandlungsschein Act): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Behandlungsschein Act): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:effectiveTime[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:effectiveTime[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:participant[@typeCode='REF'][not(@nullFlavor)]) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:participant[@typeCode='REF'][not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:participant[@typeCode='REF'][not(@nullFlavor)]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:participant[@typeCode='REF'][not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.119']]]) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.119']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.119']]]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.119']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.122']]]) &gt;= 1">(EXNDS Behandlungsschein Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.122']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.122']]]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.122']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.121']]]) &lt;= 1">(EXNDS Behandlungsschein Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.121']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']
Item: (EXNDS Behandlungsschein Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']"
         id="d45e15625-false-d570535e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Behandlungsschein Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.117')">(EXNDS Behandlungsschein Act): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.117' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:id
Item: (EXNDS Behandlungsschein Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:id"
         id="d45e15627-false-d570549e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Behandlungsschein Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Behandlungsschein Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d45e15628-false-d570562e0">
      <extends rule="CD.SDTC"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Behandlungsschein Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.37-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Behandlungsschein Act): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.37 exnds_Behandlungsscheinart_VS (DYNAMIC)' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:text
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:text"
         id="d570563e69-false-d570583e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:text/hl7:reference[not(@nullFlavor)]
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:text/hl7:reference[not(@nullFlavor)]"
         id="d570563e71-false-d570602e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="@value">(Narrative Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="starts-with(@value,'#') or starts-with(@value,'http')">(Narrative Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element, or begin with the 'http' or 'https' url-scheme.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (EXNDS Behandlungsschein Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d45e15634-false-d570616e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Behandlungsschein Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]
Item: (EXNDS Behandlungsschein Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@typeCode) = ('REF')">(EXNDS Zuweiser Body): Der Wert von typeCode MUSS 'REF' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(EXNDS Zuweiser Body): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:time) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:time kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:participantRole[hl7:playingEntity] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:participantRole[hl7:playingEntity] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.118')">(EXNDS Zuweiser Body): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.118' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:time
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:time">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(EXNDS Zuweiser Body): Der Wert von classCode MUSS 'ROL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:id) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:id) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:id kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:playingEntity[not(@nullFlavor)]) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:playingEntity[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:playingEntity[not(@nullFlavor)]) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:playingEntity[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:id
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:addr
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:addr">
      <extends rule="AD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:AD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:telecom
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:telecom">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]
Item: (EXNDS Zuweiser Body)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): Der Wert von classCode MUSS 'ENT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): Element hl7:code kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): Element hl7:desc kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:code">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): Der Elementinhalt MUSS einer von '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:quantity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:quantity">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDA PlayingEntity): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(CDA PlayingEntity): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:name
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:name">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:desc
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='REF'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:desc">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']
Item: (EXNDS Behandlungsschein Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@typeCode) = ('IND')">(EXNDS Dienstgeber): Der Wert von typeCode MUSS 'IND' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(EXNDS Dienstgeber): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.123']) &gt;= 1">(EXNDS Dienstgeber): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.123'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.123']) &lt;= 1">(EXNDS Dienstgeber): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.123'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:time) &lt;= 1">(EXNDS Dienstgeber): Element hl7:time kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]) &gt;= 1">(EXNDS Dienstgeber): Element hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]) &lt;= 1">(EXNDS Dienstgeber): Element hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.123']
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.123']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Dienstgeber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.123')">(EXNDS Dienstgeber): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.123' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:time
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:time">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Dienstgeber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(EXNDS Dienstgeber): Der Wert von classCode MUSS 'ROL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Dienstgeber): Element hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Dienstgeber): Element hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:id
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Dienstgeber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Dienstgeber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@code) = ('Dienstgeber')">(EXNDS Dienstgeber): Der Wert von code MUSS 'Dienstgeber' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Dienstgeber): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@displayName) = ('Dienstgeber') or not(@displayName)">(EXNDS Dienstgeber): Der Wert von displayName MUSS 'Dienstgeber' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Dienstgeber): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Dienstgeber): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Dienstgeber): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(EXNDS Dienstgeber): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(EXNDS Dienstgeber): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]/hl7:originalText
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]/hl7:originalText">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]/hl7:originalText/hl7:reference[not(@nullFlavor)]">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr">
      <extends rule="AD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(EXNDS Dienstgeber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:AD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.123
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:telecom
Item: (EXNDS Dienstgeber)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:participant[@typeCode='IND']/hl7:participantRole[hl7:code[(@code = 'Dienstgeber' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:telecom">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.123-2020-10-02T111751.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(EXNDS Dienstgeber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.119']]]
Item: (EXNDS Behandlungsschein Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.119']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Behandlungsschein Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlungsschein Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.122']]]
Item: (EXNDS Behandlungsschein Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.122']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Behandlungsschein Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlungsschein Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.117
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.121']]]
Item: (EXNDS Behandlungsschein Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.117']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.121']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Behandlungsschein Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.3.117-2020-10-01T171233.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlungsschein Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
