<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.31
Name: EXNDS Weitere Merkmale
Description: Diese Sektion wird als Sub-Sektion der Sektion "Weitere Patienteninformation - Medizinisch" geführt und beinhaltet weitere Merkmale wie z.B.: die Blutgruppe des Patienten/der Patientin. Die Liste der Merkmale ist nicht als vollständig definiert. Es können weitere Merkmale in Form eines Key/Value-Pairs angegeben werden.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333">
   <title>EXNDS Weitere Merkmale</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]
Item: (EXNDS Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]"
         id="d45e11556-false-d397929e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]) &lt;= 1">(EXNDS Weitere Merkmale): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]
Item: (EXNDS Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]"
         id="d45e11591-false-d397972e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(EXNDS Weitere Merkmale): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Weitere Merkmale): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']) &gt;= 1">(EXNDS Weitere Merkmale): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']) &lt;= 1">(EXNDS Weitere Merkmale): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:code[(@code = 'PAT_INFO_MED_MERK' and @codeSystem = '1.2.40.0.34.5.194')]) &gt;= 1">(EXNDS Weitere Merkmale): Element hl7:code[(@code = 'PAT_INFO_MED_MERK' and @codeSystem = '1.2.40.0.34.5.194')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:code[(@code = 'PAT_INFO_MED_MERK' and @codeSystem = '1.2.40.0.34.5.194')]) &lt;= 1">(EXNDS Weitere Merkmale): Element hl7:code[(@code = 'PAT_INFO_MED_MERK' and @codeSystem = '1.2.40.0.34.5.194')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(EXNDS Weitere Merkmale): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(EXNDS Weitere Merkmale): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Weitere Merkmale): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Weitere Merkmale): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]) &gt;= 1">(EXNDS Weitere Merkmale): Element hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]) &lt;= 1">(EXNDS Weitere Merkmale): Element hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']
Item: (EXNDS Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']"
         id="d45e11594-false-d398045e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.31')">(EXNDS Weitere Merkmale): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.31' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:code[(@code = 'PAT_INFO_MED_MERK' and @codeSystem = '1.2.40.0.34.5.194')]
Item: (EXNDS Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:code[(@code = 'PAT_INFO_MED_MERK' and @codeSystem = '1.2.40.0.34.5.194')]"
         id="d45e11596-false-d398060e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@code) = ('PAT_INFO_MED_MERK')">(EXNDS Weitere Merkmale): Der Wert von code MUSS 'PAT_INFO_MED_MERK' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.194')">(EXNDS Weitere Merkmale): Der Wert von codeSystem MUSS '1.2.40.0.34.5.194' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@displayName) = ('Weitere Merkmale') or not(@displayName)">(EXNDS Weitere Merkmale): Der Wert von displayName MUSS 'Weitere Merkmale' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Weitere Merkmale): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@codeSystemName) = ('EXNDS_Sections') or not(@codeSystemName)">(EXNDS Weitere Merkmale): Der Wert von codeSystemName MUSS 'EXNDS_Sections' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Weitere Merkmale): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:title[not(@nullFlavor)]
Item: (EXNDS Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:title[not(@nullFlavor)]"
         id="d45e11601-false-d398091e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(EXNDS Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="text()='Weitere Merkmale'">(EXNDS Weitere Merkmale): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Weitere Merkmale'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:text[not(@nullFlavor)]
Item: (EXNDS Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:text[not(@nullFlavor)]"
         id="d45e11604-false-d398105e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(EXNDS Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.31
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]
Item: (EXNDS Weitere Merkmale)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Merkmale): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.31-2019-06-13T094333.html"
              test="string(@typeCode) = ('DRIV')">(EXNDS Weitere Merkmale): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
