<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.30
Name: EXNDS Familienanamnese
Description: Diese Sektion enthält in Form eines narrativen Textes Informationen über die Familienanamnese. Eine tabellarische Darstellung wird empfohlen.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613">
   <title>EXNDS Familienanamnese</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]
Item: (EXNDS Familienanamnese)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]"
         id="d45e11516-false-d383241e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]) &lt;= 1">(EXNDS Familienanamnese): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]
Item: (EXNDS Familienanamnese)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]"
         id="d45e11531-false-d383548e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(EXNDS Familienanamnese): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Familienanamnese): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']) &gt;= 1">(EXNDS Familienanamnese): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']) &lt;= 1">(EXNDS Familienanamnese): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:code[(@code = '416471007' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(EXNDS Familienanamnese): Element hl7:code[(@code = '416471007' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:code[(@code = '416471007' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(EXNDS Familienanamnese): Element hl7:code[(@code = '416471007' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(EXNDS Familienanamnese): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(EXNDS Familienanamnese): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Familienanamnese): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Familienanamnese): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']
Item: (EXNDS Familienanamnese)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']"
         id="d45e11534-false-d383749e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Familienanamnese): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.30')">(EXNDS Familienanamnese): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.30' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:code[(@code = '416471007' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (EXNDS Familienanamnese)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:code[(@code = '416471007' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d45e11536-false-d383764e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Familienanamnese): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@code) = ('416471007')">(EXNDS Familienanamnese): Der Wert von code MUSS '416471007' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(EXNDS Familienanamnese): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.96' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@displayName) = ('Family history of clinical finding') or not(@displayName)">(EXNDS Familienanamnese): Der Wert von displayName MUSS 'Family history of clinical finding' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Familienanamnese): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(EXNDS Familienanamnese): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Familienanamnese): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:title[not(@nullFlavor)]
Item: (EXNDS Familienanamnese)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:title[not(@nullFlavor)]"
         id="d45e11541-false-d383795e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(EXNDS Familienanamnese): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="text()='Familienanamnese'">(EXNDS Familienanamnese): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Familienanamnese'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:text[not(@nullFlavor)]
Item: (EXNDS Familienanamnese)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:text[not(@nullFlavor)]"
         id="d45e11544-false-d383809e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(EXNDS Familienanamnese): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.30
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:entry[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.115']]]
Item: (EXNDS Familienanamnese)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.30']]/hl7:entry[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.115']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Familienanamnese): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.30-2019-06-13T092613.html"
              test="string(@typeCode) = ('DRIV')">(EXNDS Familienanamnese): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
