<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.100
Name: EXNDS CaveInformation Entry
Description: Strukturierte oder codierte Angabe einer Cave-Information
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535">
   <title>EXNDS CaveInformation Entry</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]
Item: (EXNDS CaveInformation Entry)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]"
         id="d45e10694-false-d295385e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@classCode) = ('OBS')">(EXNDS CaveInformation Entry): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@moodCode) = ('EVN')">(EXNDS CaveInformation Entry): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']) &gt;= 1">(EXNDS CaveInformation Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']) &lt;= 1">(EXNDS CaveInformation Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100'] kommt zu häufig vor [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:code[(@code = '80943009' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt; 1">(EXNDS CaveInformation Entry): Element hl7:code ist codiert mit Bindungsstärke 'extensible' und enthält ein Code außerhalb des angegebene Wertraums.</report>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:code[(@code = '80943009' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(EXNDS CaveInformation Entry): Element hl7:code[(@code = '80943009' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:text) &lt;= 1">(EXNDS CaveInformation Entry): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &gt;= 1">(EXNDS CaveInformation Entry): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS CaveInformation Entry): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(EXNDS CaveInformation Entry): Element hl7:value[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS CaveInformation Entry): Element hl7:value[@nullFlavor='NA'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']"
         id="d45e10697-false-d295445e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS CaveInformation Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.100')">(EXNDS CaveInformation Entry): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.100' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:id
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:id"
         id="d45e10699-false-d295459e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS CaveInformation Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:code[(@code = '80943009' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:code[(@code = '80943009' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d45e10700-false-d295470e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS CaveInformation Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@code) = ('80943009')">(EXNDS CaveInformation Entry): Der Wert von code MUSS '80943009' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(EXNDS CaveInformation Entry): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.96' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@displayName) = ('Risk factor (observable entity)') or not(@displayName)">(EXNDS CaveInformation Entry): Der Wert von displayName MUSS 'Risk factor (observable entity)' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS CaveInformation Entry): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(EXNDS CaveInformation Entry): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS CaveInformation Entry): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:text
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:text"
         id="d45e10705-false-d295501e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS CaveInformation Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[not(@nullFlavor)]
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[not(@nullFlavor)]"
         id="d45e10709-false-d295509e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS CaveInformation Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.100
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[@nullFlavor='NA']
Item: (EXNDS CaveInformation Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[@nullFlavor='NA']"
         id="d45e10712-false-d295517e0">
      <extends rule="CD"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS CaveInformation Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="string(@nullFlavor) = ('NA')">(EXNDS CaveInformation Entry): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(EXNDS CaveInformation Entry): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.2.100-2020-09-29T105535.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(EXNDS CaveInformation Entry): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[@nullFlavor='NA']/hl7:originalText
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[@nullFlavor='NA']/hl7:originalText"
         id="d295520e62-false-d295549e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.100']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d295520e68-false-d295568e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20251027T080818/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>
</pattern>
