<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.68
Name: EXNDS Visitenkilometer
Description: Angabe der Visitenkilometern unterteilt in Normal, Berg, und Alpin
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720">
   <title>EXNDS Visitenkilometer</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]
Item: (EXNDS Visitenkilometer)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]
Item: (EXNDS Visitenkilometer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]"
         id="d44e51229-false-d1568952e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="string(@classCode) = ('OBS')">(EXNDS Visitenkilometer): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Visitenkilometer): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']) &gt;= 1">(EXNDS Visitenkilometer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']) &lt;= 1">(EXNDS Visitenkilometer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Visitenkilometer): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Visitenkilometer): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Visitenkilometer): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(EXNDS Visitenkilometer): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(EXNDS Visitenkilometer): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']
Item: (EXNDS Visitenkilometer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']"
         id="d44e51232-false-d1569007e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Visitenkilometer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.68')">(EXNDS Visitenkilometer): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.68' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:id
Item: (EXNDS Visitenkilometer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:id"
         id="d44e51234-false-d1569021e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Visitenkilometer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Visitenkilometer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e51235-false-d1569034e0">
      <extends rule="CD.SDTC"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Visitenkilometer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.43-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Visitenkilometer): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.43 exnds_VisitenKMTyp_VS (DYNAMIC)' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:text
Item: (EXNDS Visitenkilometer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:text"
         id="d44e51237-false-d1569054e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Visitenkilometer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.68
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (EXNDS Visitenkilometer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]"
         id="d44e51240-false-d1569064e0">
      <extends rule="ANY"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Visitenkilometer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="@value">(EXNDS Visitenkilometer): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.68-2020-03-08T150720.html"
              test="string(@unit) = ('km') or not(@unit)">(EXNDS Visitenkilometer): Der Wert von unit MUSS 'km' sein. Gefunden: "<value-of select="@unit"/>"</assert>
   </rule>
</pattern>
