<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.65
Name: EXNDS Weitere Patienteninformation Medizinisch
Description: Organizer-Element zur Gruppierung weiterer medizinschen Patienteninformationen. Die Angabe von Vitalparameters erfolgt in einer eigenständigen Sektion
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742">
   <title>EXNDS Weitere Patienteninformation Medizinisch</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]"
         id="d44e51116-false-d1564428e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@classCode) = ('BATTERY')">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von classCode MUSS 'BATTERY' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']) &gt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:code[(@code = 'KOERPERLICHEMERKMALE' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:code[(@code = 'KOERPERLICHEMERKMALE' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:code[(@code = 'KOERPERLICHEMERKMALE' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:code[(@code = 'KOERPERLICHEMERKMALE' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:statusCode[@code = 'completed' or @nullFlavor] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:statusCode[@code = 'completed' or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:effectiveTime) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']"
         id="d44e51119-false-d1564493e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.65')">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.65' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:id
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:id"
         id="d44e51121-false-d1564507e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:code[(@code = 'KOERPERLICHEMERKMALE' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:code[(@code = 'KOERPERLICHEMERKMALE' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e51122-false-d1564518e0">
      <extends rule="CD.SDTC"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@code) = ('KOERPERLICHEMERKMALE')">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von code MUSS 'KOERPERLICHEMERKMALE' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@displayName) = ('Körperliche Merkmale') or not(@displayName)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von displayName MUSS 'Körperliche Merkmale' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Weitere Patienteninformation Medizinisch): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Weitere Patienteninformation Medizinisch): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e51127-false-d1564550e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Weitere Patienteninformation Medizinisch): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:effectiveTime
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:effectiveTime"
         id="d44e51129-false-d1564566e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.66']]]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.66']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:sequenceNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:seperatableInd) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:seperatableInd kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.66']]]/hl7:sequenceNumber
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.66']]]/hl7:sequenceNumber">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Weitere Patienteninformation Medizinisch): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.66']]]/hl7:seperatableInd
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.66']]]/hl7:seperatableInd">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:sequenceNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:seperatableInd) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:seperatableInd kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]/hl7:sequenceNumber
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]/hl7:sequenceNumber">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Weitere Patienteninformation Medizinisch): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]/hl7:seperatableInd
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.64']]]/hl7:seperatableInd">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:sequenceNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:seperatableInd) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:seperatableInd kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]/hl7:sequenceNumber
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]/hl7:sequenceNumber">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Weitere Patienteninformation Medizinisch): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]/hl7:seperatableInd
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.113']]]/hl7:seperatableInd">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.114']]]
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.114']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Patienteninformation Medizinisch): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:sequenceNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="count(hl7:seperatableInd) &lt;= 1">(EXNDS Weitere Patienteninformation Medizinisch): Element hl7:seperatableInd kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.114']]]/hl7:sequenceNumber
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.114']]]/hl7:sequenceNumber">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Weitere Patienteninformation Medizinisch): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.65
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.114']]]/hl7:seperatableInd
Item: (EXNDS Weitere Patienteninformation Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.65']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.114']]]/hl7:seperatableInd">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.65-2020-03-08T144742.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(EXNDS Weitere Patienteninformation Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
