<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.64
Name: EXNDS Rhesusfaktor Entry
Description: Codierte Angabe des Rhesusfaktors
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257">
   <title>EXNDS Rhesusfaktor Entry</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]
Item: (EXNDS Rhesusfaktor Entry)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]
Item: (EXNDS Rhesusfaktor Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]"
         id="d44e51068-false-d1564125e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@classCode) = ('OBS')">(EXNDS Rhesusfaktor Entry): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Rhesusfaktor Entry): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']) &gt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']) &lt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:code[(@code = '115758001' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:code[(@code = '115758001' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:code[(@code = '115758001' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:code[(@code = '115758001' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Rhesusfaktor Entry): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']
Item: (EXNDS Rhesusfaktor Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']"
         id="d44e51071-false-d1564181e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Rhesusfaktor Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.64')">(EXNDS Rhesusfaktor Entry): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.64' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:id
Item: (EXNDS Rhesusfaktor Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:id"
         id="d44e51073-false-d1564195e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Rhesusfaktor Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:code[(@code = '115758001' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (EXNDS Rhesusfaktor Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:code[(@code = '115758001' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d44e51074-false-d1564206e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Rhesusfaktor Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@code) = ('115758001')">(EXNDS Rhesusfaktor Entry): Der Wert von code MUSS '115758001' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(EXNDS Rhesusfaktor Entry): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.96' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@displayName) = ('Rh blood group phenotype (finding)') or not(@displayName)">(EXNDS Rhesusfaktor Entry): Der Wert von displayName MUSS 'Rh blood group phenotype (finding)' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Rhesusfaktor Entry): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(EXNDS Rhesusfaktor Entry): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Rhesusfaktor Entry): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:text
Item: (EXNDS Rhesusfaktor Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:text"
         id="d44e51079-false-d1564237e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Rhesusfaktor Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.64
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Rhesusfaktor Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.64']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e51080-false-d1564250e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Rhesusfaktor Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.64-2020-03-06T110257.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.35-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Rhesusfaktor Entry): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.35 exnds_Rhesusfaktor_VS (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
