<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.145
Name: EXNDS Arzneimittel Abgabe
Description: Angabe zur Abgabeart: Barverkauf, Kasse, öffentliche Apotheke
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200">
   <title>EXNDS Arzneimittel Abgabe</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.145
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]
Item: (EXNDS Arzneimittel Abgabe)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.145
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]
Item: (EXNDS Arzneimittel Abgabe)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]"
         id="d44e35611-false-d1278707e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@classCode) = ('OBS')">(EXNDS Arzneimittel Abgabe): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Arzneimittel Abgabe): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Arzneimittel Abgabe): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']) &gt;= 1">(EXNDS Arzneimittel Abgabe): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']) &lt;= 1">(EXNDS Arzneimittel Abgabe): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="count(hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Arzneimittel Abgabe): Element hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="count(hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Arzneimittel Abgabe): Element hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.46-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(EXNDS Arzneimittel Abgabe): Element hl7:value ist codiert mit Bindungsstärke 'extensible' und enthält ein Code außerhalb des angegebene Wertraums.</report>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.46-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Arzneimittel Abgabe): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.46-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.145
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']
Item: (EXNDS Arzneimittel Abgabe)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']"
         id="d44e35615-false-d1278756e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Arzneimittel Abgabe): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.145')">(EXNDS Arzneimittel Abgabe): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.145' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.145
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]/hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Arzneimittel Abgabe)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]/hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e35617-false-d1278771e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Arzneimittel Abgabe): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@code) = ('ArnMittelPackArt')">(EXNDS Arzneimittel Abgabe): Der Wert von code MUSS 'ArnMittelPackArt' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Arzneimittel Abgabe): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@displayName) = ('Arzneimittelpakungsart') or not(@displayName)">(EXNDS Arzneimittel Abgabe): Der Wert von displayName MUSS 'Arzneimittelpakungsart' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Arzneimittel Abgabe): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Arzneimittel Abgabe): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Arzneimittel Abgabe): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.145
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.46-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Arzneimittel Abgabe)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.145']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.46-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e35622-false-d1278805e0">
      <extends rule="CD"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.46-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Arzneimittel Abgabe): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.46 exnds_ArzneimittelAbgabeTyp_VS (DYNAMIC)' sein.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.145-2020-10-06T171200.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Arzneimittel Abgabe): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
