<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.144
Name: EXNDS Arzneimittel Packungsart
Description: Angabe zur Packungsart des Arzneimittels
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257">
   <title>EXNDS Arzneimittel Packungsart</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.144
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]
Item: (EXNDS Arzneimittel Packungsart)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.144
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]
Item: (EXNDS Arzneimittel Packungsart)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]"
         id="d44e35585-false-d1278496e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@classCode) = ('OBS')">(EXNDS Arzneimittel Packungsart): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Arzneimittel Packungsart): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Arzneimittel Packungsart): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']) &gt;= 1">(EXNDS Arzneimittel Packungsart): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']) &lt;= 1">(EXNDS Arzneimittel Packungsart): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="count(hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Arzneimittel Packungsart): Element hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="count(hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Arzneimittel Packungsart): Element hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.45-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(EXNDS Arzneimittel Packungsart): Element hl7:value ist codiert mit Bindungsstärke 'extensible' und enthält ein Code außerhalb des angegebene Wertraums.</report>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.45-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Arzneimittel Packungsart): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.45-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.144
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']
Item: (EXNDS Arzneimittel Packungsart)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']"
         id="d44e35589-false-d1278545e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Arzneimittel Packungsart): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.144')">(EXNDS Arzneimittel Packungsart): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.144' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.144
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]/hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Arzneimittel Packungsart)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]/hl7:code[(@code = 'ArnMittelPackArt' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e35591-false-d1278560e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Arzneimittel Packungsart): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@code) = ('ArnMittelPackArt')">(EXNDS Arzneimittel Packungsart): Der Wert von code MUSS 'ArnMittelPackArt' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Arzneimittel Packungsart): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@displayName) = ('Arzneimittelpakungsart') or not(@displayName)">(EXNDS Arzneimittel Packungsart): Der Wert von displayName MUSS 'Arzneimittelpakungsart' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Arzneimittel Packungsart): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Arzneimittel Packungsart): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Arzneimittel Packungsart): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.144
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.45-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Arzneimittel Packungsart)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.144']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.45-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e35596-false-d1278594e0">
      <extends rule="CD"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.45-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Arzneimittel Packungsart): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.45 exnds_ArzneimittelPackungsArt_VS (DYNAMIC)' sein.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.144-2020-10-06T170257.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Arzneimittel Packungsart): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
