<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.132
Name: EXNDS Tarif Act
Description: Angabe der notwendigen Information für den Tarif
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759">
   <title>EXNDS Tarif Act</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]
Item: (EXNDS Tarif Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]
Item: (EXNDS Tarif Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]"
         id="d44e34731-false-d859349e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@classCode) = ('ACT')">(EXNDS Tarif Act): Der Wert von classCode MUSS 'ACT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Tarif Act): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']) &gt;= 1">(EXNDS Tarif Act): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']) &lt;= 1">(EXNDS Tarif Act): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:code[(@code = 'Tarif' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Tarif Act): Element hl7:code[(@code = 'Tarif' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:code[(@code = 'Tarif' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Tarif Act): Element hl7:code[(@code = 'Tarif' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Tarif Act): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Tarif Act): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(EXNDS Tarif Act): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(EXNDS Tarif Act): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:effectiveTime) &lt;= 1">(EXNDS Tarif Act): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]) &lt;= 1">(EXNDS Tarif Act): Element hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]) &lt;= 1">(EXNDS Tarif Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]) &lt;= 1">(EXNDS Tarif Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]) &lt;= 1">(EXNDS Tarif Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]) &lt;= 1">(EXNDS Tarif Act): Element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.134']]]) &lt;= 1">(EXNDS Tarif Act): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.134']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']
Item: (EXNDS Tarif Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']"
         id="d44e34734-false-d859510e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Tarif Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.132')">(EXNDS Tarif Act): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.132' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:id
Item: (EXNDS Tarif Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:id"
         id="d44e34736-false-d859524e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Tarif Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:code[(@code = 'Tarif' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Tarif Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:code[(@code = 'Tarif' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e34737-false-d859535e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Tarif Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@code) = ('Tarif')">(EXNDS Tarif Act): Der Wert von code MUSS 'Tarif' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Tarif Act): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@displayName) = ('Tarif') or not(@displayName)">(EXNDS Tarif Act): Der Wert von displayName MUSS 'Tarif' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Tarif Act): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Tarif Act): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Tarif Act): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:text
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:text"
         id="d859536e89-false-d859567e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:text/hl7:reference[not(@nullFlavor)]
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:text/hl7:reference[not(@nullFlavor)]"
         id="d859536e91-false-d859586e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="@value">(Narrative Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="starts-with(@value,'#') or starts-with(@value,'http')">(Narrative Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element, or begin with the 'http' or 'https' url-scheme.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:statusCode[@code = 'completed']
Item: (EXNDS Tarif Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:statusCode[@code = 'completed']"
         id="d44e34746-false-d859601e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Tarif Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Tarif Act): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:effectiveTime
Item: (EXNDS Tarif Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:effectiveTime"
         id="d44e34748-false-d859617e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Tarif Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]
Item: (EXNDS Tarif Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@typeCode) = ('REF')">(EXNDS Zuweiser Body): Der Wert von typeCode MUSS 'REF' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(EXNDS Zuweiser Body): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:time) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:time kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:participantRole[hl7:playingEntity] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:participantRole[hl7:playingEntity]) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:participantRole[hl7:playingEntity] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.118')">(EXNDS Zuweiser Body): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.118' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:time
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:time">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(EXNDS Zuweiser Body): Der Wert von classCode MUSS 'ROL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:id) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:id) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:id kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:playingEntity[not(@nullFlavor)]) &gt;= 1">(EXNDS Zuweiser Body): Element hl7:playingEntity[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="count(hl7:playingEntity[not(@nullFlavor)]) &lt;= 1">(EXNDS Zuweiser Body): Element hl7:playingEntity[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:id
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:addr
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:addr">
      <extends rule="AD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:AD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:telecom
Item: (EXNDS Zuweiser Body)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:telecom">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.118-2020-10-01T172011.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(EXNDS Zuweiser Body): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.118
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]
Item: (EXNDS Zuweiser Body)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): Der Wert von classCode MUSS 'ENT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): Element hl7:code kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): Element hl7:desc kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:code">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): Der Elementinhalt MUSS einer von '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:quantity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:quantity">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(CDA PlayingEntity): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(CDA PlayingEntity): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:name
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:name">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:desc
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:participant[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.118']]/hl7:participantRole[hl7:playingEntity]/hl7:playingEntity[not(@nullFlavor)]/hl7:desc">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(CDA PlayingEntity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]
Item: (EXNDS Tarif Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Tarif Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Tarif Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]
Item: (EXNDS Tarif Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Tarif Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Tarif Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]
Item: (EXNDS Tarif Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Tarif Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Tarif Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]
Item: (EXNDS Tarif Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Tarif Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Tarif Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.134']]]
Item: (EXNDS Tarif Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.134']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Tarif Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Tarif Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.132
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]
Item: (EXNDS Tarif Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.132']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.135']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Tarif Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.132-2020-10-02T150759.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Tarif Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
