<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.128
Name: EXNDS Chefarztkennzeichen
Description: Angabe des Chefarztkennzeichen in den Ausprägungen ja/nein/trägerspezifisch
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556">
   <title>EXNDS Chefarztkennzeichen</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]
Item: (EXNDS Chefarztkennzeichen)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]
Item: (EXNDS Chefarztkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]"
         id="d44e34553-false-d854856e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@classCode) = ('OBS')">(EXNDS Chefarztkennzeichen): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Chefarztkennzeichen): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Chefarztkennzeichen): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']) &gt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']) &lt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:code[(@code = 'CHKZ' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:code[(@code = 'CHKZ' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:code[(@code = 'CHKZ' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:code[(@code = 'CHKZ' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']
Item: (EXNDS Chefarztkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']"
         id="d44e34557-false-d854920e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Chefarztkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.128')">(EXNDS Chefarztkennzeichen): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.128' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:id
Item: (EXNDS Chefarztkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:id"
         id="d44e34559-false-d854934e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Chefarztkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:code[(@code = 'CHKZ' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Chefarztkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:code[(@code = 'CHKZ' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e34560-false-d854945e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Chefarztkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@code) = ('CHKZ')">(EXNDS Chefarztkennzeichen): Der Wert von code MUSS 'CHKZ' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Chefarztkennzeichen): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@displayName) = ('Chefarztkennzeichen') or not(@displayName)">(EXNDS Chefarztkennzeichen): Der Wert von displayName MUSS 'Chefarztkennzeichen' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Chefarztkennzeichen): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Chefarztkennzeichen): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Chefarztkennzeichen): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:statusCode[@code = 'completed']
Item: (EXNDS Chefarztkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:statusCode[@code = 'completed']"
         id="d44e34565-false-d854977e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Chefarztkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Chefarztkennzeichen): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.128
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Chefarztkennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e34567-false-d854999e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Chefarztkennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Chefarztkennzeichen): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.44 exnds_Chefarztkennzeichen_VS (DYNAMIC)' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.128-2020-10-02T140556.html"
              test="count(hl7:originalText) &lt;= 1">(EXNDS Chefarztkennzeichen): Element hl7:originalText kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:originalText
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:originalText"
         id="d855002e58-false-d855032e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.128']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.44-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d855002e64-false-d855051e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>
</pattern>
