<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.125
Name: EXNDS Regiezuschlag
Description: Angabe eines etwaigen Regiezuschlages für eine Therapie
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420">
   <title>EXNDS Regiezuschlag</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]
Item: (EXNDS Regiezuschlag)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]
Item: (EXNDS Regiezuschlag)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]"
         id="d44e34443-false-d854220e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@classCode) = ('OBS')">(EXNDS Regiezuschlag): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Regiezuschlag): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Regiezuschlag): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']) &gt;= 1">(EXNDS Regiezuschlag): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']) &lt;= 1">(EXNDS Regiezuschlag): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:code[(@code = 'RGZ' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Regiezuschlag): Element hl7:code[(@code = 'RGZ' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:code[(@code = 'RGZ' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Regiezuschlag): Element hl7:code[(@code = 'RGZ' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Regiezuschlag): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Regiezuschlag): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(EXNDS Regiezuschlag): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(EXNDS Regiezuschlag): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(EXNDS Regiezuschlag): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(EXNDS Regiezuschlag): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']
Item: (EXNDS Regiezuschlag)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']"
         id="d44e34447-false-d854293e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Regiezuschlag): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.125')">(EXNDS Regiezuschlag): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.125' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:id
Item: (EXNDS Regiezuschlag)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:id"
         id="d44e34449-false-d854307e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Regiezuschlag): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:code[(@code = 'RGZ' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Regiezuschlag)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:code[(@code = 'RGZ' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e34450-false-d854318e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Regiezuschlag): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@code) = ('RGZ')">(EXNDS Regiezuschlag): Der Wert von code MUSS 'RGZ' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Regiezuschlag): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@displayName) = ('Regiezuschlag') or not(@displayName)">(EXNDS Regiezuschlag): Der Wert von displayName MUSS 'Regiezuschlag' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Regiezuschlag): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Regiezuschlag): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Regiezuschlag): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:text
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:text"
         id="d854319e89-false-d854350e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:text/hl7:reference[not(@nullFlavor)]
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:text/hl7:reference[not(@nullFlavor)]"
         id="d854319e91-false-d854369e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="@value">(Narrative Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="starts-with(@value,'#') or starts-with(@value,'http')">(Narrative Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element, or begin with the 'http' or 'https' url-scheme.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:statusCode[@code = 'completed']
Item: (EXNDS Regiezuschlag)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:statusCode[@code = 'completed']"
         id="d44e34459-false-d854384e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Regiezuschlag): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Regiezuschlag): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.125
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (EXNDS Regiezuschlag)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.125']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]"
         id="d44e34461-false-d854400e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Regiezuschlag): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="@value">(EXNDS Regiezuschlag): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="@unit">(EXNDS Regiezuschlag): Attribut @unit MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.125-2020-10-02T132420.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(EXNDS Regiezuschlag): Attribute @unit MUSS vom Datentyp 'cs' sein  - '<value-of select="@unit"/>'</assert>
   </rule>
</pattern>
