<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.112
Name: EXNDS Patient Erstzuweiser Entry
Description: Strukturierte Angabe über den Erstzuweiser.  Woher hat der Patient den Kontakt bzw. die Kontaktdaten? Kann auch Google, Facebook usw. sein.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959">
   <title>EXNDS Patient Erstzuweiser Entry</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]"
         id="d44e33760-false-d830543e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@classCode) = ('OBS')">(EXNDS Patient Erstzuweiser Entry): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Patient Erstzuweiser Entry): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']) &gt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']) &lt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:code[(@code = 'ERSTZUW' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:code[(@code = 'ERSTZUW' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:code[(@code = 'ERSTZUW' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:code[(@code = 'ERSTZUW' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:value[@nullFlavor='NA']) &gt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:value[@nullFlavor='NA'] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:value[@nullFlavor='NA'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']"
         id="d44e33763-false-d830593e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Erstzuweiser Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.112')">(EXNDS Patient Erstzuweiser Entry): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.112' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:id
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:id"
         id="d44e33765-false-d830607e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Erstzuweiser Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:code[(@code = 'ERSTZUW' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:code[(@code = 'ERSTZUW' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e33766-false-d830618e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Erstzuweiser Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@code) = ('ERSTZUW')">(EXNDS Patient Erstzuweiser Entry): Der Wert von code MUSS 'ERSTZUW' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Patient Erstzuweiser Entry): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@displayName) = ('Erstzuweiser') or not(@displayName)">(EXNDS Patient Erstzuweiser Entry): Der Wert von displayName MUSS 'Erstzuweiser' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Patient Erstzuweiser Entry): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Patient Erstzuweiser Entry): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Patient Erstzuweiser Entry): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:text
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:text"
         id="d44e33771-false-d830649e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Patient Erstzuweiser Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.112
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:value[@nullFlavor='NA']
Item: (EXNDS Patient Erstzuweiser Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:value[@nullFlavor='NA']"
         id="d44e33772-false-d830657e0">
      <extends rule="CD"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Patient Erstzuweiser Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="string(@nullFlavor) = ('NA')">(EXNDS Patient Erstzuweiser Entry): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.112-2020-09-25T150959.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(EXNDS Patient Erstzuweiser Entry): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:value[@nullFlavor='NA']/hl7:originalText
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:value[@nullFlavor='NA']/hl7:originalText"
         id="d830660e62-false-d830689e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.112']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d830660e68-false-d830708e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>
</pattern>
