<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.110
Name: EXNDS Patient Entfernung Entry
Description: Angabe zur Entfernung des Wohnortes des Patienten in km
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135">
   <title>EXNDS Patient Entfernung Entry</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]
Item: (EXNDS Patient Entfernung Entry)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]
Item: (EXNDS Patient Entfernung Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]"
         id="d44e33697-false-d830023e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@classCode) = ('OBS')">(EXNDS Patient Entfernung Entry): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Patient Entfernung Entry): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']) &gt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']) &lt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:code[(@code = 'EKM' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:code[(@code = 'EKM' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:code[(@code = 'EKM' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:code[(@code = 'EKM' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(EXNDS Patient Entfernung Entry): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']
Item: (EXNDS Patient Entfernung Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']"
         id="d44e33700-false-d830076e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Entfernung Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.110')">(EXNDS Patient Entfernung Entry): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.110' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:id
Item: (EXNDS Patient Entfernung Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:id"
         id="d44e33702-false-d830090e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Entfernung Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:code[(@code = 'EKM' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Patient Entfernung Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:code[(@code = 'EKM' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e33703-false-d830101e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Entfernung Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@code) = ('EKM')">(EXNDS Patient Entfernung Entry): Der Wert von code MUSS 'EKM' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Patient Entfernung Entry): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@displayName) = ('EntfernungInKM') or not(@displayName)">(EXNDS Patient Entfernung Entry): Der Wert von displayName MUSS 'EntfernungInKM' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Patient Entfernung Entry): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Patient Entfernung Entry): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Patient Entfernung Entry): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:text
Item: (EXNDS Patient Entfernung Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:text"
         id="d44e33708-false-d830132e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Patient Entfernung Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.110
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (EXNDS Patient Entfernung Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.110']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]"
         id="d44e33709-false-d830142e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(EXNDS Patient Entfernung Entry): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(EXNDS Patient Entfernung Entry): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Patient Entfernung Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="string(@unit) = ('km')">(EXNDS Patient Entfernung Entry): Der Wert von unit MUSS 'km' sein. Gefunden: "<value-of select="@unit"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.3.110-2020-09-25T145135.html"
              test="@value">(EXNDS Patient Entfernung Entry): Attribut @value MUSS vorkommen.</assert>
   </rule>
</pattern>
