<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.67
Name: EXNDS Weitere Patienteninformation - Medizinisch
Description: Diese Sektion enthält weitere medizinische Information zum Patienten/zur Patientin. Diese Informationen werden in die Sub-Sektionen "Vitalparameter" und "Weitere Merkmale" unterteilt. Vitalparameter umfassen Angaben zu: - Sauerstoffsättigung - Körpergewicht - Körperoberfläche - Kopfumfang okzipital-frontal - Körpergröße - Körpergröße (liegend) - Körpertemperatur -  Blutdruck diastolisch - Blutdruck, mittel - Blutdruck systolisch - Puls - Atemfrequenz
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838">
   <title>EXNDS Weitere Patienteninformation - Medizinisch</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]"
         id="d44e29165-false-d636555e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]"
         id="d44e29214-false-d636822e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']) &gt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:code[(@code = 'PAT_INFO_MED' and @codeSystem = '1.2.40.0.34.5.194')]) &gt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:code[(@code = 'PAT_INFO_MED' and @codeSystem = '1.2.40.0.34.5.194')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:code[(@code = 'PAT_INFO_MED' and @codeSystem = '1.2.40.0.34.5.194')]) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:code[(@code = 'PAT_INFO_MED' and @codeSystem = '1.2.40.0.34.5.194')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.46'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.16'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.1.5.3.2']]]) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.46'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.16'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.1.5.3.2']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]) &lt;= 1">(EXNDS Weitere Patienteninformation - Medizinisch): Element hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']"
         id="d44e29217-false-d637013e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Weitere Patienteninformation - Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.67')">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.67' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:code[(@code = 'PAT_INFO_MED' and @codeSystem = '1.2.40.0.34.5.194')]
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:code[(@code = 'PAT_INFO_MED' and @codeSystem = '1.2.40.0.34.5.194')]"
         id="d44e29219-false-d637028e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Weitere Patienteninformation - Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@code) = ('PAT_INFO_MED')">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von code MUSS 'PAT_INFO_MED' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.194')">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von codeSystem MUSS '1.2.40.0.34.5.194' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@displayName) = ('Weitere Patienteninformation - Medizinisch') or not(@displayName)">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von displayName MUSS 'Weitere Patienteninformation - Medizinisch' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Weitere Patienteninformation - Medizinisch): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@codeSystemName) = ('EXNDS_Sections') or not(@codeSystemName)">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von codeSystemName MUSS 'EXNDS_Sections' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Weitere Patienteninformation - Medizinisch): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:title[not(@nullFlavor)]
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:title[not(@nullFlavor)]"
         id="d44e29224-false-d637059e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(EXNDS Weitere Patienteninformation - Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="text()='Weitere Patienteninformation - Medizinisch'">(EXNDS Weitere Patienteninformation - Medizinisch): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Weitere Patienteninformation - Medizinisch'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:text
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:text"
         id="d44e29227-false-d637073e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(EXNDS Weitere Patienteninformation - Medizinisch): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.46'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.16'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.1.5.3.2']]]
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.46'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.16'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.1.5.3.2']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.67
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]
Item: (EXNDS Weitere Patienteninformation - Medizinisch)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.67']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.31']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.67-2019-06-13T093838.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Weitere Patienteninformation - Medizinisch): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
