<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.39
Name: EXNDS Krankenstand
Description: Diese Sektion enthält Angaben zu den Krankenständen des Patienten/der Patientin. Die strukturierte Angabe erfolgt mit Hilfe einer Tabelle.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032">
   <title>EXNDS Krankenstand</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]
Item: (EXNDS Krankenstand)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]"
         id="d44e27772-false-d530744e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]) &lt;= 1">(EXNDS Krankenstand): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]
Item: (EXNDS Krankenstand)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]"
         id="d44e27787-false-d530775e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(EXNDS Krankenstand): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Krankenstand): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']) &gt;= 1">(EXNDS Krankenstand): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']) &lt;= 1">(EXNDS Krankenstand): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:code[(@code = '224459001' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(EXNDS Krankenstand): Element hl7:code[(@code = '224459001' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:code[(@code = '224459001' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(EXNDS Krankenstand): Element hl7:code[(@code = '224459001' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(EXNDS Krankenstand): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(EXNDS Krankenstand): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Krankenstand): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Krankenstand): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="count(hl7:entry[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.159']]]) &gt;= 1">(EXNDS Krankenstand): Element hl7:entry[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.159']]] ist required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']
Item: (EXNDS Krankenstand)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']"
         id="d44e27790-false-d530840e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Krankenstand): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.39')">(EXNDS Krankenstand): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.39' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:code[(@code = '224459001' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (EXNDS Krankenstand)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:code[(@code = '224459001' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d44e27792-false-d530855e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Krankenstand): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@code) = ('224459001')">(EXNDS Krankenstand): Der Wert von code MUSS '224459001' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(EXNDS Krankenstand): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.96' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@displayName) = ('On sick leave from work') or not(@displayName)">(EXNDS Krankenstand): Der Wert von displayName MUSS 'On sick leave from work' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Krankenstand): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(EXNDS Krankenstand): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Krankenstand): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:title[not(@nullFlavor)]
Item: (EXNDS Krankenstand)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:title[not(@nullFlavor)]"
         id="d44e27797-false-d530886e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(EXNDS Krankenstand): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="text()='Krankenstand'">(EXNDS Krankenstand): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Krankenstand'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:text[not(@nullFlavor)]
Item: (EXNDS Krankenstand)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:text[not(@nullFlavor)]"
         id="d44e27800-false-d530900e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(EXNDS Krankenstand): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.39
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:entry[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.159']]]
Item: (EXNDS Krankenstand)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.39']]/hl7:entry[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.159']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Krankenstand): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.39-2019-06-17T153032.html"
              test="string(@typeCode) = ('DRIV')">(EXNDS Krankenstand): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
