<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.34
Name: EXNDS Karteineintragungen
Description: In dieser Sektion können die Karteieintragungen aus dem Arztpraxissoftwaresystem angegeben werden. Die Angabe erfolgt in strukturierter Form mit Hilfe einer Tabelle.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237">
   <title>EXNDS Karteineintragungen</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]
Item: (EXNDS Karteineintragungen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]"
         id="d44e27594-false-d507283e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]) &lt;= 1">(EXNDS Karteineintragungen): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]
Item: (EXNDS Karteineintragungen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]"
         id="d44e27609-false-d507310e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(EXNDS Karteineintragungen): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Karteineintragungen): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']) &gt;= 1">(EXNDS Karteineintragungen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']) &lt;= 1">(EXNDS Karteineintragungen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:code[(@code = 'KARTEI_EINTRAGUNGEN' and @codeSystem = '1.2.40.0.34.5.194')]) &gt;= 1">(EXNDS Karteineintragungen): Element hl7:code[(@code = 'KARTEI_EINTRAGUNGEN' and @codeSystem = '1.2.40.0.34.5.194')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:code[(@code = 'KARTEI_EINTRAGUNGEN' and @codeSystem = '1.2.40.0.34.5.194')]) &lt;= 1">(EXNDS Karteineintragungen): Element hl7:code[(@code = 'KARTEI_EINTRAGUNGEN' and @codeSystem = '1.2.40.0.34.5.194')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(EXNDS Karteineintragungen): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(EXNDS Karteineintragungen): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Karteineintragungen): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Karteineintragungen): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) &gt;= 1">(EXNDS Karteineintragungen): Element hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) &lt;= 1">(EXNDS Karteineintragungen): Element hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']
Item: (EXNDS Karteineintragungen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']"
         id="d44e27612-false-d507375e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Karteineintragungen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.34')">(EXNDS Karteineintragungen): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.34' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:code[(@code = 'KARTEI_EINTRAGUNGEN' and @codeSystem = '1.2.40.0.34.5.194')]
Item: (EXNDS Karteineintragungen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:code[(@code = 'KARTEI_EINTRAGUNGEN' and @codeSystem = '1.2.40.0.34.5.194')]"
         id="d44e27614-false-d507390e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Karteineintragungen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@code) = ('KARTEI_EINTRAGUNGEN')">(EXNDS Karteineintragungen): Der Wert von code MUSS 'KARTEI_EINTRAGUNGEN' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.194')">(EXNDS Karteineintragungen): Der Wert von codeSystem MUSS '1.2.40.0.34.5.194' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@displayName) = ('Karteineintragungen') or not(@displayName)">(EXNDS Karteineintragungen): Der Wert von displayName MUSS 'Karteineintragungen' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Karteineintragungen): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@codeSystemName) = ('EXNDS_Sections') or not(@codeSystemName)">(EXNDS Karteineintragungen): Der Wert von codeSystemName MUSS 'EXNDS_Sections' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Karteineintragungen): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:title[not(@nullFlavor)]
Item: (EXNDS Karteineintragungen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:title[not(@nullFlavor)]"
         id="d44e27619-false-d507421e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(EXNDS Karteineintragungen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="text()='Karteineintragungen'">(EXNDS Karteineintragungen): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Karteineintragungen'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:text[not(@nullFlavor)]
Item: (EXNDS Karteineintragungen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:text[not(@nullFlavor)]"
         id="d44e27622-false-d507435e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(EXNDS Karteineintragungen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.34
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]
Item: (EXNDS Karteineintragungen)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.34']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Karteineintragungen): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250908T133352/tmp-1.2.40.0.34.6.0.11.2.34-2019-06-14T090237.html"
              test="string(@typeCode) = ('DRIV')">(EXNDS Karteineintragungen): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
