<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.67
Name: EXNDS Behandlungen Organizer
Description: Organizer-Element zum Zusammenfassen der Behandlungen
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518">
   <title>EXNDS Behandlungen Organizer</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]
Item: (EXNDS Behandlungen Organizer)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]
Item: (EXNDS Behandlungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]"
         id="d44e50115-false-d1433141e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@classCode) = ('BATTERY')">(EXNDS Behandlungen Organizer): Der Wert von classCode MUSS 'BATTERY' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Behandlungen Organizer): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']) &gt;= 1">(EXNDS Behandlungen Organizer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']) &lt;= 1">(EXNDS Behandlungen Organizer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:code[(@code = 'Behandlungen' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Behandlungen Organizer): Element hl7:code[(@code = 'Behandlungen' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:code[(@code = 'Behandlungen' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Behandlungen Organizer): Element hl7:code[(@code = 'Behandlungen' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(EXNDS Behandlungen Organizer): Element hl7:statusCode[@code = 'completed' or @nullFlavor] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(EXNDS Behandlungen Organizer): Element hl7:statusCode[@code = 'completed' or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:effectiveTime) &lt;= 1">(EXNDS Behandlungen Organizer): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:component[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]) &gt;= 1">(EXNDS Behandlungen Organizer): Element hl7:component[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]] ist mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']
Item: (EXNDS Behandlungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']"
         id="d44e50118-false-d1433242e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Behandlungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.67')">(EXNDS Behandlungen Organizer): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.67' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:id
Item: (EXNDS Behandlungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:id"
         id="d44e50120-false-d1433256e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Behandlungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:code[(@code = 'Behandlungen' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Behandlungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:code[(@code = 'Behandlungen' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e50121-false-d1433267e0">
      <extends rule="CD.SDTC"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Behandlungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@code) = ('Behandlungen')">(EXNDS Behandlungen Organizer): Der Wert von code MUSS 'Behandlungen' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Behandlungen Organizer): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@displayName) = ('Behandlungen') or not(@displayName)">(EXNDS Behandlungen Organizer): Der Wert von displayName MUSS 'Behandlungen' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Behandlungen Organizer): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Behandlungen Organizer): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Behandlungen Organizer): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (EXNDS Behandlungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e50126-false-d1433299e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Behandlungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Behandlungen Organizer): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:effectiveTime
Item: (EXNDS Behandlungen Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:effectiveTime"
         id="d44e50128-false-d1433315e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Behandlungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:component[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]
Item: (EXNDS Behandlungen Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:component[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Behandlungen Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlungen Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="count(hl7:sequenceNumber) &lt;= 1">(EXNDS Behandlungen Organizer): Element hl7:sequenceNumber kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.67
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:component[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:sequenceNumber
Item: (EXNDS Behandlungen Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.67']]/hl7:component[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:sequenceNumber">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(EXNDS Behandlungen Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Behandlungen Organizer): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="@value">(EXNDS Behandlungen Organizer): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.67-2020-03-08T150518.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(EXNDS Behandlungen Organizer): Attribute @value ist keine gültige int Zahl <value-of select="@value"/>
      </assert>
   </rule>
</pattern>
