<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.157
Name: EXNDS Krankenstand Grund
Description: Strukturierte Angabe zum Grund eines Krankenstandes
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313">
   <title>EXNDS Krankenstand Grund</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]
Item: (EXNDS Krankenstand Grund)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]
Item: (EXNDS Krankenstand Grund)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]"
         id="d44e35116-false-d1157425e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@classCode) = ('OBS')">(EXNDS Krankenstand Grund): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Krankenstand Grund): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']) &gt;= 1">(EXNDS Krankenstand Grund): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']) &lt;= 1">(EXNDS Krankenstand Grund): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:code[(@code = 'KrankenstandGrund' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Krankenstand Grund): Element hl7:code[(@code = 'KrankenstandGrund' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:code[(@code = 'KrankenstandGrund' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Krankenstand Grund): Element hl7:code[(@code = 'KrankenstandGrund' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Krankenstand Grund): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:value[@nullFlavor='NA']) &gt;= 1">(EXNDS Krankenstand Grund): Element hl7:value[@nullFlavor='NA'] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Krankenstand Grund): Element hl7:value[@nullFlavor='NA'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']
Item: (EXNDS Krankenstand Grund)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']"
         id="d44e35119-false-d1157475e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Krankenstand Grund): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.157')">(EXNDS Krankenstand Grund): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.157' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:id
Item: (EXNDS Krankenstand Grund)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:id"
         id="d44e35121-false-d1157489e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Krankenstand Grund): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:code[(@code = 'KrankenstandGrund' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Krankenstand Grund)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:code[(@code = 'KrankenstandGrund' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e35122-false-d1157500e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Krankenstand Grund): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@code) = ('KrankenstandGrund')">(EXNDS Krankenstand Grund): Der Wert von code MUSS 'KrankenstandGrund' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Krankenstand Grund): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@displayName) = ('Grund für den Krankenstand') or not(@displayName)">(EXNDS Krankenstand Grund): Der Wert von displayName MUSS 'Grund für den Krankenstand' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Krankenstand Grund): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Krankenstand Grund): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Krankenstand Grund): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:text
Item: (EXNDS Krankenstand Grund)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:text"
         id="d44e35127-false-d1157531e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Krankenstand Grund): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.157
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:value[@nullFlavor='NA']
Item: (EXNDS Krankenstand Grund)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:value[@nullFlavor='NA']"
         id="d44e35128-false-d1157539e0">
      <extends rule="CD"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Krankenstand Grund): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="string(@nullFlavor) = ('NA')">(EXNDS Krankenstand Grund): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(EXNDS Krankenstand Grund): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.157-2020-11-06T135313.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(EXNDS Krankenstand Grund): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:value[@nullFlavor='NA']/hl7:originalText
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:value[@nullFlavor='NA']/hl7:originalText"
         id="d1157542e62-false-d1157571e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.157']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d1157542e68-false-d1157590e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>
</pattern>
