<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.150
Name: EXNDS Befund Act
Description: Dieses Act-Element enthält jeweils einen Befund. Diese Angabe kann entweder über Karteieintragungen oder über ein ExternalDocument erfolgen.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738">
   <title>EXNDS Befund Act</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]
Item: (EXNDS Befund Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]
Item: (EXNDS Befund Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]"
         id="d44e34904-false-d1147403e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']) &gt;= 1">(EXNDS Befund Act): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']) &lt;= 1">(EXNDS Befund Act): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:id) &lt;= 1">(EXNDS Befund Act): Element hl7:id kommt zu häufig vor [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.47-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(EXNDS Befund Act): Element hl7:code ist codiert mit Bindungsstärke 'extensible' und enthält ein Code außerhalb des angegebene Wertraums.</report>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.47-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Befund Act): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.47-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]] | hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) &gt;= 1">(EXNDS Befund Act): Auswahl (hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]]  oder  hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]] | hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) &lt;= 1">(EXNDS Befund Act): Auswahl (hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]]  oder  hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]]) &lt;= 1">(EXNDS Befund Act): Element hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="count(hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]) &lt;= 1">(EXNDS Befund Act): Element hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']
Item: (EXNDS Befund Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']"
         id="d44e34905-false-d1147481e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Befund Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.150')">(EXNDS Befund Act): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.150' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:id
Item: (EXNDS Befund Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:id"
         id="d44e34907-false-d1147495e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Befund Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.47-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Befund Act)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.47-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e34910-false-d1147508e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Befund Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.47-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Befund Act): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.47 exnds_BefundArt_VS (DYNAMIC)' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:reference[hl7:externalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.151']]]
Item: (EXNDS Befund Act)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.150
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]
Item: (EXNDS Befund Act)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.150']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.137']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Befund Act): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.150-2020-10-16T112738.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Befund Act): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
