<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.143
Name: EXNDS Arzneimittel-Organizer
Description: Dieses Organizer-Element dient dazu, Informationen zu einzelnen Verordnungen zu sammeln, welche NICHT im Medikation Verordnungs Entry untergebracht werden. Beispiele hierzu wären Preisinformation zu Arnzeimittel
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659">
   <title>EXNDS Arzneimittel-Organizer</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]
Item: (EXNDS Arzneimittel-Organizer)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]
Item: (EXNDS Arzneimittel-Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]"
         id="d44e34676-false-d1144446e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@classCode) = ('BATTERY')">(EXNDS Arzneimittel-Organizer): Der Wert von classCode MUSS 'BATTERY' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Arzneimittel-Organizer): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']) &gt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:id[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:code[(@code = 'ArnMittelOrganizer' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:code[(@code = 'ArnMittelOrganizer' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:code[(@code = 'ArnMittelOrganizer' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:code[(@code = 'ArnMittelOrganizer' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:statusCode[@code = 'completed' or @nullFlavor] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:statusCode[@code = 'completed' or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.140']]]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.140']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.141']]]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.141']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.144']]]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.144']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:component[hl7:organizer[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.146']]]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:component[hl7:organizer[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.146']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.148']]]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.148']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.149']]]) &lt;= 1">(EXNDS Arzneimittel-Organizer): Element hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.149']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']
Item: (EXNDS Arzneimittel-Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']"
         id="d44e34679-false-d1144521e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Arzneimittel-Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.143')">(EXNDS Arzneimittel-Organizer): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.143' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:id[not(@nullFlavor)]
Item: (EXNDS Arzneimittel-Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:id[not(@nullFlavor)]"
         id="d44e34681-false-d1144535e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Arzneimittel-Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:code[(@code = 'ArnMittelOrganizer' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Arzneimittel-Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:code[(@code = 'ArnMittelOrganizer' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e34684-false-d1144546e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Arzneimittel-Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@code) = ('ArnMittelOrganizer')">(EXNDS Arzneimittel-Organizer): Der Wert von code MUSS 'ArnMittelOrganizer' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Arzneimittel-Organizer): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@displayName) = ('Arzneimittel-Organizer') or not(@displayName)">(EXNDS Arzneimittel-Organizer): Der Wert von displayName MUSS 'Arzneimittel-Organizer' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Arzneimittel-Organizer): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Arzneimittel-Organizer): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Arzneimittel-Organizer): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (EXNDS Arzneimittel-Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e34689-false-d1144578e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Arzneimittel-Organizer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Arzneimittel-Organizer): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.140']]]
Item: (EXNDS Arzneimittel-Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.140']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Arzneimittel-Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Arzneimittel-Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.141']]]
Item: (EXNDS Arzneimittel-Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.141']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Arzneimittel-Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Arzneimittel-Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.144']]]
Item: (EXNDS Arzneimittel-Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.144']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Arzneimittel-Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Arzneimittel-Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:organizer[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.146']]]
Item: (EXNDS Arzneimittel-Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:organizer[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.146']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Arzneimittel-Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Arzneimittel-Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.148']]]
Item: (EXNDS Arzneimittel-Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.148']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Arzneimittel-Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Arzneimittel-Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.143
Context: *[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.149']]]
Item: (EXNDS Arzneimittel-Organizer)
-->
   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]]/hl7:organizer[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.143']]/hl7:component[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.149']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Arzneimittel-Organizer): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.143-2020-10-06T165659.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Arzneimittel-Organizer): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
