<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.140
Name: EXNDS Preis Arzneimittel TAX
Description: Angabe des TAX-Preises eines Arzneimittels
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249">
   <title>EXNDS Preis Arzneimittel TAX</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.140
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]
Item: (EXNDS Preis Arzneimittel TAX)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.140
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]
Item: (EXNDS Preis Arzneimittel TAX)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]"
         id="d44e34557-false-d1143529e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@classCode) = ('OBS')">(EXNDS Preis Arzneimittel TAX): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Preis Arzneimittel TAX): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Preis Arzneimittel TAX): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']) &gt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']) &lt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:code[(@code = 'ArzMittelPreisTAX' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:code[(@code = 'ArzMittelPreisTAX' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:code[(@code = 'ArzMittelPreisTAX' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:code[(@code = 'ArzMittelPreisTAX' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.142']]]) &lt;= 1">(EXNDS Preis Arzneimittel TAX): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.142']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.140
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']
Item: (EXNDS Preis Arzneimittel TAX)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']"
         id="d44e34561-false-d1143583e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Preis Arzneimittel TAX): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.140')">(EXNDS Preis Arzneimittel TAX): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.140' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.140
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:code[(@code = 'ArzMittelPreisTAX' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Preis Arzneimittel TAX)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:code[(@code = 'ArzMittelPreisTAX' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e34563-false-d1143598e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Preis Arzneimittel TAX): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@code) = ('ArzMittelPreisTAX')">(EXNDS Preis Arzneimittel TAX): Der Wert von code MUSS 'ArzMittelPreisTAX' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Preis Arzneimittel TAX): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@displayName) = ('TAX-Preis des Arzneimittels') or not(@displayName)">(EXNDS Preis Arzneimittel TAX): Der Wert von displayName MUSS 'TAX-Preis des Arzneimittels' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Preis Arzneimittel TAX): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Preis Arzneimittel TAX): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Preis Arzneimittel TAX): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.140
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (EXNDS Preis Arzneimittel TAX)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]"
         id="d44e34568-false-d1143629e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Preis Arzneimittel TAX): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="@value">(EXNDS Preis Arzneimittel TAX): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="@unit">(EXNDS Preis Arzneimittel TAX): Attribut @unit MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(EXNDS Preis Arzneimittel TAX): Attribute @unit MUSS vom Datentyp 'cs' sein  - '<value-of select="@unit"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.140
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.142']]]
Item: (EXNDS Preis Arzneimittel TAX)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.140']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.142']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Preis Arzneimittel TAX): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.140-2020-10-06T155249.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Preis Arzneimittel TAX): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
