<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.133
Name: EXNDS Abrechnungskennzeichen
Description: Codierte Angabe des Abrechnungskennzeichens. Codes basierend auf DVP
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608">
   <title>EXNDS Abrechnungskennzeichen</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]
Item: (EXNDS Abrechnungskennzeichen)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]
Item: (EXNDS Abrechnungskennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]"
         id="d44e33918-false-d728978e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@classCode) = ('OBS')">(EXNDS Abrechnungskennzeichen): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Abrechnungskennzeichen): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']) &gt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']) &lt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:code[(@code = 'ABR' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:code[(@code = 'ABR' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:code[(@code = 'ABR' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:code[(@code = 'ABR' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Abrechnungskennzeichen): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']
Item: (EXNDS Abrechnungskennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']"
         id="d44e33921-false-d729034e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Abrechnungskennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.133')">(EXNDS Abrechnungskennzeichen): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.133' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:id
Item: (EXNDS Abrechnungskennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:id"
         id="d44e33923-false-d729048e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Abrechnungskennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:code[(@code = 'ABR' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Abrechnungskennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:code[(@code = 'ABR' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e33924-false-d729059e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Abrechnungskennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@code) = ('ABR')">(EXNDS Abrechnungskennzeichen): Der Wert von code MUSS 'ABR' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Abrechnungskennzeichen): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@displayName) = ('Abrechnungs-Kennzeichen') or not(@displayName)">(EXNDS Abrechnungskennzeichen): Der Wert von displayName MUSS 'Abrechnungs-Kennzeichen' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Abrechnungskennzeichen): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Abrechnungskennzeichen): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Abrechnungskennzeichen): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:text
Item: (EXNDS Abrechnungskennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:text"
         id="d44e33929-false-d729090e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Abrechnungskennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.133
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Abrechnungskennzeichen)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.133']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e33930-false-d729103e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Abrechnungskennzeichen): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.133-2020-10-02T151608.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.42-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Abrechnungskennzeichen): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.42 exnds_AbrechnungsKennzeichen_VS (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
