<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.130
Name: EXNDS Behandlung
Description: Angaben zu einer Behandlung. Inkludiert u.a. Angaben zur Therapie und zu dem Tarif
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132">
   <title>EXNDS Behandlung</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]
Item: (EXNDS Behandlung)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]
Item: (EXNDS Behandlung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]"
         id="d44e33773-false-d723662e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@classCode) = ('PROC')">(EXNDS Behandlung): Der Wert von classCode MUSS 'PROC' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Behandlung): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']) &gt;= 1">(EXNDS Behandlung): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']) &lt;= 1">(EXNDS Behandlung): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:code[(@code = '277132007' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(EXNDS Behandlung): Element hl7:code[(@code = '277132007' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:code[(@code = '277132007' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(EXNDS Behandlung): Element hl7:code[(@code = '277132007' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(EXNDS Behandlung): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(EXNDS Behandlung): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(EXNDS Behandlung): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(EXNDS Behandlung): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:effectiveTime) &gt;= 1">(EXNDS Behandlung): Element hl7:effectiveTime ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:effectiveTime) &lt;= 1">(EXNDS Behandlung): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:participant[@typeCode='IND'][not(@nullFlavor)]) &gt;= 1">(EXNDS Behandlung): Element hl7:participant[@typeCode='IND'][not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:participant[@typeCode='IND'][not(@nullFlavor)]) &lt;= 1">(EXNDS Behandlung): Element hl7:participant[@typeCode='IND'][not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.126']]]) &gt;= 1">(EXNDS Behandlung): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.126']]] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.126']]]) &lt;= 1">(EXNDS Behandlung): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.126']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:entryRelationship[hl7:procedure[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.124']]]) &gt;= 1">(EXNDS Behandlung): Element hl7:entryRelationship[hl7:procedure[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.124']]] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.132']]]) &gt;= 1">(EXNDS Behandlung): Element hl7:entryRelationship[hl7:act[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.132']]] ist required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']
Item: (EXNDS Behandlung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']"
         id="d44e33776-false-d723752e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Behandlung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.130')">(EXNDS Behandlung): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.130' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:id
Item: (EXNDS Behandlung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:id"
         id="d44e33778-false-d723766e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Behandlung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:code[(@code = '277132007' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (EXNDS Behandlung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:code[(@code = '277132007' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d44e33779-false-d723777e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Behandlung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@code) = ('277132007')">(EXNDS Behandlung): Der Wert von code MUSS '277132007' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.96')">(EXNDS Behandlung): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.96' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@displayName) = ('Therapeutic procedure (procedure)') or not(@displayName)">(EXNDS Behandlung): Der Wert von displayName MUSS 'Therapeutic procedure (procedure)' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Behandlung): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(EXNDS Behandlung): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Behandlung): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:text
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:text"
         id="d723778e89-false-d723809e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Narrative Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.1
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:text/hl7:reference[not(@nullFlavor)]
Item: (Narrative Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:text/hl7:reference[not(@nullFlavor)]"
         id="d723778e91-false-d723828e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Narrative Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="@value">(Narrative Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.1-2021-05-06T093820.html"
              test="starts-with(@value,'#') or starts-with(@value,'http')">(Narrative Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element, or begin with the 'http' or 'https' url-scheme.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:statusCode[@code = 'completed']
Item: (EXNDS Behandlung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:statusCode[@code = 'completed']"
         id="d44e33788-false-d723843e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(EXNDS Behandlung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="@nullFlavor or (@code='completed')">(EXNDS Behandlung): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:effectiveTime
Item: (EXNDS Behandlung)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:effectiveTime"
         id="d44e33790-false-d723859e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Behandlung): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]
Item: (EXNDS Behandlung)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]">
      <extends rule="d723877e0-false-d723881e0"/>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.131
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]
Item: (EXNDS Menge Therapie)
-->
   <rule fpi="RULC-1" id="d723877e0-false-d723881e0" abstract="true">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@typeCode) = ('IND')">(EXNDS Menge Therapie): Der Wert von typeCode MUSS 'IND' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(EXNDS Menge Therapie): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.131']) &gt;= 1">(EXNDS Menge Therapie): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.131'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.131']) &lt;= 1">(EXNDS Menge Therapie): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.131'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]) &gt;= 1">(EXNDS Menge Therapie): Element hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]) &lt;= 1">(EXNDS Menge Therapie): Element hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.131
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.131']
Item: (EXNDS Menge Therapie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.131']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Menge Therapie): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.131')">(EXNDS Menge Therapie): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.131' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.131
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]
Item: (EXNDS Menge Therapie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(EXNDS Menge Therapie): Der Wert von classCode MUSS 'ROL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]) &gt;= 1">(EXNDS Menge Therapie): Element hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]) &lt;= 1">(EXNDS Menge Therapie): Element hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.131
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]/hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]
Item: (EXNDS Menge Therapie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]/hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Menge Therapie): Element hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Menge Therapie): Element hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:quantity[not(@nullFlavor)]) &gt;= 1">(EXNDS Menge Therapie): Element hl7:quantity[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="count(hl7:quantity[not(@nullFlavor)]) &lt;= 1">(EXNDS Menge Therapie): Element hl7:quantity[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.131
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]/hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Menge Therapie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]/hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]">
      <extends rule="CO.EPSOS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CO')">(EXNDS Menge Therapie): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CO" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@code) = ('TherapieMenge')">(EXNDS Menge Therapie): Der Wert von code MUSS 'TherapieMenge' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Menge Therapie): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@displayName) = ('Therapie Menge') or not(@displayName)">(EXNDS Menge Therapie): Der Wert von displayName MUSS 'Therapie Menge' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Menge Therapie): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Menge Therapie): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Menge Therapie): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.131
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]/hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:quantity[not(@nullFlavor)]
Item: (EXNDS Menge Therapie)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]]/hl7:playingEntity[hl7:code[(@code = 'TherapieMenge' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(EXNDS Menge Therapie): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(EXNDS Menge Therapie): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.131-2020-10-02T145611.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(EXNDS Menge Therapie): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.126']]]
Item: (EXNDS Behandlung)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.126']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Behandlung): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlung): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.124']]]
Item: (EXNDS Behandlung)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.124']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Behandlung): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlung): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.130
Context: *[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.132']]]
Item: (EXNDS Behandlung)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]]/hl7:procedure[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.130']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root='1.2.40.0.34.6.0.11.3.132']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Behandlung): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.130-2020-10-02T144132.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Behandlung): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
