<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.129
Name: EXNDS Visiteninformation
Description: Strukturierte und Kodierte Angabe zu Visiten
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621">
   <title>EXNDS Visiteninformation</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]
Item: (EXNDS Visiteninformation)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]
Item: (EXNDS Visiteninformation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]"
         id="d44e33725-false-d722529e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@classCode) = ('ACT')">(EXNDS Visiteninformation): Der Wert von classCode MUSS 'ACT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Visiteninformation): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(EXNDS Visiteninformation): Attribute @negationInd MUSS vom Datentyp 'bl' sein  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']) &gt;= 1">(EXNDS Visiteninformation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']) &lt;= 1">(EXNDS Visiteninformation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:code[(@code = 'Visiteninformation' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Visiteninformation): Element hl7:code[(@code = 'Visiteninformation' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:code[(@code = 'Visiteninformation' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Visiteninformation): Element hl7:code[(@code = 'Visiteninformation' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:participant[@typeCode='IND'][not(@nullFlavor)]) &gt;= 1">(EXNDS Visiteninformation): Element hl7:participant[@typeCode='IND'][not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:participant[@typeCode='IND'][not(@nullFlavor)]) &lt;= 1">(EXNDS Visiteninformation): Element hl7:participant[@typeCode='IND'][not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]) &gt;= 1">(EXNDS Visiteninformation): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]) &lt;= 3">(EXNDS Visiteninformation): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]] kommt zu häufig vor [max 3x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']
Item: (EXNDS Visiteninformation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']"
         id="d44e33729-false-d722587e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Visiteninformation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.129')">(EXNDS Visiteninformation): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.129' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:id
Item: (EXNDS Visiteninformation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:id"
         id="d44e33731-false-d722601e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Visiteninformation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:code[(@code = 'Visiteninformation' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Visiteninformation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:code[(@code = 'Visiteninformation' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e33732-false-d722612e0">
      <extends rule="CD.SDTC"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Visiteninformation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@code) = ('Visiteninformation')">(EXNDS Visiteninformation): Der Wert von code MUSS 'Visiteninformation' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Visiteninformation): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@displayName) = ('Visiteninformation') or not(@displayName)">(EXNDS Visiteninformation): Der Wert von displayName MUSS 'Visiteninformation' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Visiteninformation): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Visiteninformation): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Visiteninformation): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]
Item: (EXNDS Visiteninformation)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]
Item: (EXNDS Visitenadresse)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@typeCode) = ('IND')">(EXNDS Visitenadresse): Der Wert von typeCode MUSS 'IND' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(EXNDS Visitenadresse): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="count(hl7:time) &lt;= 1">(EXNDS Visitenadresse): Element hl7:time kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="count(hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]) &gt;= 1">(EXNDS Visitenadresse): Element hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="count(hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]) &lt;= 1">(EXNDS Visitenadresse): Element hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:time
Item: (EXNDS Visitenadresse)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:time">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(EXNDS Visitenadresse): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]
Item: (EXNDS Visitenadresse)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(EXNDS Visitenadresse): Der Wert von classCode MUSS 'ROL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="count(hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Visitenadresse): Element hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="count(hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Visitenadresse): Element hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(EXNDS Visitenadresse): Element hl7:addr[not(@nullFlavor)] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:id
Item: (EXNDS Visitenadresse)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Visitenadresse): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Visitenadresse)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Visitenadresse): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@code) = ('Visitenadresse')">(EXNDS Visitenadresse): Der Wert von code MUSS 'Visitenadresse' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Visitenadresse): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@displayName) = ('Visitenadresse') or not(@displayName)">(EXNDS Visitenadresse): Der Wert von displayName MUSS 'Visitenadresse' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Visitenadresse): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Visitenadresse): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Visitenadresse): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]
Item: (EXNDS Visitenadresse)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:streetAddressLine
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:streetName
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:houseNumber
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:city[not(@nullFlavor)]
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:state
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:country[not(@nullFlavor)]
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="string-length(text()) = 3">(Address Compilation): Es wird EMPFOHLEN, den Staat im ISO 3 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:additionalLocator
Item: (Address Compilation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:addr[not(@nullFlavor)]/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.25-2023-04-13T132100.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.127
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:telecom
Item: (EXNDS Visitenadresse)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:participant[@typeCode='IND'][not(@nullFlavor)]/hl7:participantRole[hl7:code[(@code = 'Visitenadresse' and @codeSystem = '1.2.40.0.34.5.195')]]/hl7:telecom">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.127-2020-10-02T134408.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(EXNDS Visitenadresse): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.129
Context: *[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]
Item: (EXNDS Visiteninformation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]]/hl7:act[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.129']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.68']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@typeCode) = ('COMP')">(EXNDS Visiteninformation): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.129-2020-10-02T141621.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Visiteninformation): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
