<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.114
Name: EXNDS Patient Weitere Merkmale
Description: Strukturierte Angabe oder codierte Angabe zu weiteren Merkmalen welche in der gegenständlichen Spezifikation nicht enthalten sind. Es MUSS sichergestellt werden, dass dieses Element zumindest einen observation/code und ein observation/value-Element enthält. Zweiteres kann unterschiedlichste Ausprägungen haben: entweder erfolgt eine codierte Angabe oder auch nur einen Referenz auf einen Textinhalt in section/text. Hierbei MUSS das value-Element einen NullFlavor="NA" führen und über das Konstrukt "originalText/reference" auf den original Level 2 Text dereferenzieren. Es ist zudem sicherzustellen, dass ein etwaiger Empfänger der Daten die genutzten Konzepte interpretieren kann. Hierzu kann entweder auf nationale oder internationale Codesystem referenziert werden oder im Kontext des Exportnormdatensatzes könnten die genutzten Codes in der XDM Ordnerstruktur beigelegt werden.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344">
   <title>EXNDS Patient Weitere Merkmale</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]
Item: (EXNDS Patient Weitere Merkmale)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]"
         id="d44e32961-false-d698438e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="string(@classCode) = ('OBS')">(EXNDS Patient Weitere Merkmale): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Patient Weitere Merkmale): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']) &gt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']) &lt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114'] kommt zu häufig vor [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt; 1">(EXNDS Patient Weitere Merkmale): Element hl7:code ist codiert mit Bindungsstärke 'extensible' und enthält ein Code außerhalb des angegebene Wertraums.</report>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:code[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &gt;= 1">(EXNDS Patient Weitere Merkmale): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Patient Weitere Merkmale): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NA']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:value[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:value[@nullFlavor='NA']) &lt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:value[@nullFlavor='NA'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']"
         id="d44e32964-false-d698497e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.114')">(EXNDS Patient Weitere Merkmale): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.114' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:id
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:id"
         id="d44e32966-false-d698511e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:code[not(@nullFlavor)]
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:code[not(@nullFlavor)]"
         id="d44e32967-false-d698521e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:text
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:text"
         id="d44e32968-false-d698531e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Patient Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[not(@nullFlavor)]
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[not(@nullFlavor)]"
         id="d44e32970-false-d698539e0">
      <extends rule="CD"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Patient Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="@code">(EXNDS Patient Weitere Merkmale): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(EXNDS Patient Weitere Merkmale): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="@codeSystem">(EXNDS Patient Weitere Merkmale): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(EXNDS Patient Weitere Merkmale): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.114
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[@nullFlavor='NA']
Item: (EXNDS Patient Weitere Merkmale)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[@nullFlavor='NA']"
         id="d44e32974-false-d698560e0">
      <extends rule="CD"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(EXNDS Patient Weitere Merkmale): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="string(@nullFlavor) = ('NA')">(EXNDS Patient Weitere Merkmale): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.114-2020-09-28T174344.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(EXNDS Patient Weitere Merkmale): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[@nullFlavor='NA']/hl7:originalText
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[@nullFlavor='NA']/hl7:originalText"
         id="d698563e62-false-d698592e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.114']]/hl7:value[@nullFlavor='NA']/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d698563e68-false-d698611e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>
</pattern>
