<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.111
Name: EXNDS Patient Bundesland Code Entry
Description: Codierte Angabe des Bundeslandcodes
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818">
   <title>EXNDS Patient Bundesland Code Entry</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]"
         id="d44e32864-false-d697517e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@classCode) = ('OBS')">(EXNDS Patient Bundesland Code Entry): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@moodCode) = ('EVN')">(EXNDS Patient Bundesland Code Entry): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']) &gt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']) &lt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:code[(@code = 'BLD' and @codeSystem = '1.2.40.0.34.5.195')]) &gt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:code[(@code = 'BLD' and @codeSystem = '1.2.40.0.34.5.195')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:code[(@code = 'BLD' and @codeSystem = '1.2.40.0.34.5.195')]) &lt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:code[(@code = 'BLD' and @codeSystem = '1.2.40.0.34.5.195')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:text) &lt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="count(hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(EXNDS Patient Bundesland Code Entry): Element hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']"
         id="d44e32867-false-d697573e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Bundesland Code Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.111')">(EXNDS Patient Bundesland Code Entry): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.111' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:id
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:id"
         id="d44e32869-false-d697587e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Patient Bundesland Code Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:code[(@code = 'BLD' and @codeSystem = '1.2.40.0.34.5.195')]
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:code[(@code = 'BLD' and @codeSystem = '1.2.40.0.34.5.195')]"
         id="d44e32870-false-d697598e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Bundesland Code Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@code) = ('BLD')">(EXNDS Patient Bundesland Code Entry): Der Wert von code MUSS 'BLD' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.195')">(EXNDS Patient Bundesland Code Entry): Der Wert von codeSystem MUSS '1.2.40.0.34.5.195' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@displayName) = ('Bundeslandcode') or not(@displayName)">(EXNDS Patient Bundesland Code Entry): Der Wert von displayName MUSS 'Bundeslandcode' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Patient Bundesland Code Entry): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="string(@codeSystemName) = ('EXNDS_Concepts') or not(@codeSystemName)">(EXNDS Patient Bundesland Code Entry): Der Wert von codeSystemName MUSS 'EXNDS_Concepts' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Patient Bundesland Code Entry): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:text
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:text"
         id="d44e32875-false-d697629e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(EXNDS Patient Bundesland Code Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.111
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (EXNDS Patient Bundesland Code Entry)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.111']]/hl7:value[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e32876-false-d697642e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(EXNDS Patient Bundesland Code Entry): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.3.111-2020-09-25T145818.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.6.0.10.33-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(EXNDS Patient Bundesland Code Entry): Der Elementinhalt MUSS einer von '1.2.40.0.34.6.0.10.33 exnds_BundeslandCodes_VS (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
