<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.104
Name: EXNDS Speciality-Section Container
Description: Diese Sektion ermöglicht es Befundbereich (Specialities), wie diese im Kontext des ELGA Laborbefundes definiert sind, in einer Sektion zusammenzufassen. Man könnte diese Sektion mit einem eigenständigen ELGA Laborbefund vergleichen, welcher mehrere Laborbereiche zusammenfasst.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650">
   <title>EXNDS Speciality-Section Container</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]
Item: (EXNDS Speciality-Section Container)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]"
         id="d44e25067-false-d184868e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]) &lt;= 1">(EXNDS Speciality-Section Container): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]
Item: (EXNDS Speciality-Section Container)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]"
         id="d44e25081-false-d184927e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(EXNDS Speciality-Section Container): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(EXNDS Speciality-Section Container): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']) &gt;= 1">(EXNDS Speciality-Section Container): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']) &lt;= 1">(EXNDS Speciality-Section Container): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:code[(@code = 'LabSpecContainer' and @codeSystem = '1.2.40.0.34.5.194')]) &gt;= 1">(EXNDS Speciality-Section Container): Element hl7:code[(@code = 'LabSpecContainer' and @codeSystem = '1.2.40.0.34.5.194')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:code[(@code = 'LabSpecContainer' and @codeSystem = '1.2.40.0.34.5.194')]) &lt;= 1">(EXNDS Speciality-Section Container): Element hl7:code[(@code = 'LabSpecContainer' and @codeSystem = '1.2.40.0.34.5.194')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(EXNDS Speciality-Section Container): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(EXNDS Speciality-Section Container): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:text) = 0">(EXNDS Speciality-Section Container): Element hl7:text DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.1']]]) &gt;= 1">(EXNDS Speciality-Section Container): Element hl7:component[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.1']]] ist mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']
Item: (EXNDS Speciality-Section Container)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']"
         id="d44e25084-false-d185005e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(EXNDS Speciality-Section Container): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.104')">(EXNDS Speciality-Section Container): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.104' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:code[(@code = 'LabSpecContainer' and @codeSystem = '1.2.40.0.34.5.194')]
Item: (EXNDS Speciality-Section Container)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:code[(@code = 'LabSpecContainer' and @codeSystem = '1.2.40.0.34.5.194')]"
         id="d44e25086-false-d185020e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(EXNDS Speciality-Section Container): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@code) = ('LabSpecContainer')">(EXNDS Speciality-Section Container): Der Wert von code MUSS 'LabSpecContainer' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@codeSystem) = ('1.2.40.0.34.5.194')">(EXNDS Speciality-Section Container): Der Wert von codeSystem MUSS '1.2.40.0.34.5.194' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@displayName) = ('Laboratory Speciality Container') or not(@displayName)">(EXNDS Speciality-Section Container): Der Wert von displayName MUSS 'Laboratory Speciality Container' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(EXNDS Speciality-Section Container): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@codeSystemName) = ('EXNDS_Sections') or not(@codeSystemName)">(EXNDS Speciality-Section Container): Der Wert von codeSystemName MUSS 'EXNDS_Sections' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(EXNDS Speciality-Section Container): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:title[not(@nullFlavor)]
Item: (EXNDS Speciality-Section Container)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:title[not(@nullFlavor)]"
         id="d44e25091-false-d185051e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(EXNDS Speciality-Section Container): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="text()='Laborparameter'">(EXNDS Speciality-Section Container): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Laborparameter'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:text
Item: (EXNDS Speciality-Section Container)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:text"
         id="d44e25094-false-d185065e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(EXNDS Speciality-Section Container): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.104
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:component[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.1']]]
Item: (EXNDS Speciality-Section Container)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.104']]/hl7:component[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.1']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(EXNDS Speciality-Section Container): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.6.0.11.2.104-2021-02-11T131650.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(EXNDS Speciality-Section Container): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
