<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.11.13.3.7
Name: Problem Entry Gesundheitsproblem
Description: Mit dieser Observation wird ein bekanntes relevantes Gesundheitsproblem des Patienten codiert dargestellt. Die Zeitspanne, in der ein Gesundheitsproblem besteht oder bestanden hat, wird hier angegeben.  
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.11.13.3.7-2017-08-13T150852">
   <title>Problem Entry Gesundheitsproblem</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]"
         id="d44e1465-false-d5808e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]"
         id="d44e1531-false-d5845e0">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@classCode) = ('OBS')">(Problem Entry Gesundheitsproblem): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@moodCode) = ('EVN')">(Problem Entry Gesundheitsproblem): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:templateId[@root = '1.2.40.0.34.11.13.3.7'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:templateId[@root = '1.2.40.0.34.11.13.3.7'] kommt zu häufig vor [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(Problem Entry Gesundheitsproblem): Element hl7:code ist codiert mit Bindungsstärke 'extensible' und enthält ein Code außerhalb des angegebene Wertraums.</report>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:effectiveTime[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:effectiveTime[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NI']) &gt;= 1">(Problem Entry Gesundheitsproblem): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NI']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:value[not(@nullFlavor)] | hl7:value[not(@nullFlavor)] | hl7:value[@nullFlavor='NI']) &lt;= 1">(Problem Entry Gesundheitsproblem): Auswahl (hl7:value[not(@nullFlavor)]  oder  hl7:value[not(@nullFlavor)]  oder  hl7:value[@nullFlavor='NI']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:value[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:value[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:value[@nullFlavor='NI']) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:value[@nullFlavor='NI'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.21']]]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.21']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.18']]]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.18']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.19']]]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.19']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.13']]]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.13']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']"
         id="d44e1537-false-d5959e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@root) = ('1.2.40.0.34.11.13.3.7')">(Problem Entry Gesundheitsproblem): Der Wert von root MUSS '1.2.40.0.34.11.13.3.7' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:id
Item: (Problem Entry Gesundheitsproblem)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.35-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e1548-false-d5984e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.35-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Problem Entry Gesundheitsproblem): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.35 atcdabbr_Problemarten_VS (DYNAMIC)' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:statusCode[@code = 'completed']
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:statusCode[@code = 'completed']"
         id="d44e1564-false-d6005e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@nullFlavor or (@code='completed')">(Problem Entry Gesundheitsproblem): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d44e1572-false-d6021e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:low) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:low ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:low) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:low kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:high) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:high kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low"
         id="d44e1574-false-d6046e0">
      <extends rule="IVXB_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVXB_TS')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVXB_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high"
         id="d44e1580-false-d6056e0">
      <extends rule="IVXB_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVXB_TS')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVXB_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]"
         id="d44e1637-false-d6064e0">
      <extends rule="CD"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@code">(Problem Entry Gesundheitsproblem): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Problem Entry Gesundheitsproblem): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@codeSystem">(Problem Entry Gesundheitsproblem): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Problem Entry Gesundheitsproblem): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:originalText) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:originalText kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText"
         id="d44e1675-false-d6096e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d44e1677-false-d6115e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:translation
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:translation"
         id="d44e1685-false-d6125e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]"
         id="d44e1698-false-d6133e0">
      <extends rule="CD"/>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.179-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Problem Entry Gesundheitsproblem): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.179 ELGA_AbsentOrUnknownProblems (DYNAMIC)' sein.</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@code">(Problem Entry Gesundheitsproblem): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Problem Entry Gesundheitsproblem): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@codeSystem">(Problem Entry Gesundheitsproblem): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Problem Entry Gesundheitsproblem): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:originalText) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:originalText kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText"
         id="d44e1712-false-d6174e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:originalText/hl7:reference[not(@nullFlavor)]"
         id="d44e1714-false-d6193e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:translation
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[not(@nullFlavor)]/hl7:translation"
         id="d44e1721-false-d6203e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[@nullFlavor='NI']
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[@nullFlavor='NI']"
         id="d44e1734-false-d6211e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[@nullFlavor='NI']/hl7:originalText[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[@nullFlavor='NI']/hl7:originalText[not(@nullFlavor)]"
         id="d44e1747-false-d6232e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Problem Entry Gesundheitsproblem): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[@nullFlavor='NI']/hl7:originalText[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]
Item: (Problem Entry Gesundheitsproblem)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:value[@nullFlavor='NI']/hl7:originalText[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]"
         id="d44e1749-false-d6251e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Problem Entry Gesundheitsproblem): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.21']]]
Item: (Problem Entry Gesundheitsproblem)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.21']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@typeCode) = ('SUBJ')">(Problem Entry Gesundheitsproblem): Der Wert von typeCode MUSS 'SUBJ' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@inversionInd) = ('true')">(Problem Entry Gesundheitsproblem): Der Wert von inversionInd MUSS 'true' sein. Gefunden: "<value-of select="@inversionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.18']]]
Item: (Problem Entry Gesundheitsproblem)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.18']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@typeCode) = ('SUBJ')">(Problem Entry Gesundheitsproblem): Der Wert von typeCode MUSS 'SUBJ' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@inversionInd) = ('true')">(Problem Entry Gesundheitsproblem): Der Wert von inversionInd MUSS 'true' sein. Gefunden: "<value-of select="@inversionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.19']]]
Item: (Problem Entry Gesundheitsproblem)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.19']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@typeCode) = ('SUBJ')">(Problem Entry Gesundheitsproblem): Der Wert von typeCode MUSS 'SUBJ' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@inversionInd) = ('true')">(Problem Entry Gesundheitsproblem): Der Wert von inversionInd MUSS 'true' sein. Gefunden: "<value-of select="@inversionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.11.13.3.7
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.13']]]
Item: (Problem Entry Gesundheitsproblem)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.7']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.11.13.3.13']]]">
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@typeCode) = ('REFR')">(Problem Entry Gesundheitsproblem): Der Wert von typeCode MUSS 'REFR' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/index.php?prefix=exnds-exnds-html-20250901T072217/tmp-1.2.40.0.34.11.13.3.7-2017-08-13T150852.html"
              test="string(@inversionInd) = ('false')">(Problem Entry Gesundheitsproblem): Der Wert von inversionInd MUSS 'false' sein. Gefunden: "<value-of select="@inversionInd"/>"</assert>
   </rule>
</pattern>
