<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction EMS Labormeldung v1 (2.16.840.1.113883.2.16.777.3.4.6 2023-05-09T07:41:58)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <ns uri="urn:ihe:pharm" prefix="pharm"/>
   <ns uri="urn:hl7-at:v3" prefix="hl7at"/>
   <ns uri="urn:hl7-org:ips" prefix="ips"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'EMSLabormeldung'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario EMSLabormeldung -->

   <!-- epims_document_labormeldung -->
   <pattern>
      <title>epims_document_labormeldung</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.11.1'] and hl7:templateId[@root = '1.2.40.0.34.11.6'] and hl7:templateId[@root = '1.2.40.0.34.11.6.0.1']]"
                 see="https://elga.art-decor.org/epims-html-20251024T105528/tmp-1.2.40.0.34.11.6.0.1-2020-02-25T144658.html">(Labormeldung): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.11.1'] and hl7:templateId[@root = '1.2.40.0.34.11.6'] and hl7:templateId[@root = '1.2.40.0.34.11.6.0.1']]</assert>
      </rule>
   </pattern>
   <include href="include/1.2.40.0.34.11.6.0.1-2020-02-25T144658.sch"/>
   <include href="include/1.2.40.0.34.11.6.0.1-2020-02-25T144658-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-1.2.40.0.34.11.6.0.1-2020-02-25T144658"/>
      <active pattern="template-1.2.40.0.34.11.4.3.2-2015-01-30T000000"/>
      <active pattern="template-1.2.40.0.34.11.4.3.3-2014-12-06T000000"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.86-2020-04-22T144121"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.55-2020-02-20T141708"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.61-2020-02-20T161229"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.91-2020-04-22T153159"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.92-2020-04-22T153509"/>
      <active pattern="template-1.3.6.1.4.1.19376.1.3.1.1.1-2013-09-09T000000"/>
      <active pattern="template-1.3.6.1.4.1.19376.1.3.1.6-2020-06-15T085028"/>
   </phase>
   <phase id="epims_document_labormeldung">
      <active pattern="template-1.2.40.0.34.11.6.0.1-2020-02-25T144658"/>
   </phase>
   <phase id="epims_document_labormeldung-closed">
      <active pattern="template-1.2.40.0.34.11.6.0.1-2020-02-25T144658-closed"/>
   </phase>
   <phase id="Annotation">
      <active pattern="template-1.2.40.0.34.11.4.3.2-2015-01-30T000000"/>
   </phase>
   <phase id="LaboratoryPerformer2">
      <active pattern="template-1.2.40.0.34.11.4.3.3-2014-12-06T000000"/>
   </phase>
   <phase id="epims_section_EMSSectionLabormeldung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.86-2020-04-22T144121"/>
   </phase>
   <phase id="epims_section_EMSSectionLabormeldung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.86-2020-04-22T144121-closed"/>
   </phase>
   <phase id="epims_entry_specimenCollection">
      <active pattern="template-1.2.40.0.34.6.0.11.3.55-2020-02-20T141708"/>
   </phase>
   <phase id="epims_entry_specimenCollection-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.55-2020-02-20T141708-closed"/>
   </phase>
   <phase id="epims_entry_EMSOrganizerLabor">
      <active pattern="template-1.2.40.0.34.6.0.11.3.61-2020-02-20T161229"/>
   </phase>
   <phase id="epims_entry_EMSOrganizerLabor-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.61-2020-02-20T161229-closed"/>
   </phase>
   <phase id="epims_entry_caseIdentificationLabor">
      <active pattern="template-1.2.40.0.34.6.0.11.3.91-2020-04-22T153159"/>
   </phase>
   <phase id="epims_entry_caseIdentificationLabor-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.91-2020-04-22T153159-closed"/>
   </phase>
   <phase id="epims_entry_notificationOrganizerLabor">
      <active pattern="template-1.2.40.0.34.6.0.11.3.92-2020-04-22T153509"/>
   </phase>
   <phase id="epims_entry_notificationOrganizerLabor-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.92-2020-04-22T153509-closed"/>
   </phase>
   <phase id="NotifiableCondition">
      <active pattern="template-1.3.6.1.4.1.19376.1.3.1.1.1-2013-09-09T000000"/>
   </phase>
   <phase id="LaboratoryObservation">
      <active pattern="template-1.3.6.1.4.1.19376.1.3.1.6-2020-06-15T085028"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- Annotation -->
   <include href="include/1.2.40.0.34.11.4.3.2-2015-01-30T000000.sch"/>
   <!-- LaboratoryPerformer2 -->
   <include href="include/1.2.40.0.34.11.4.3.3-2014-12-06T000000.sch"/>
   <!-- epims_section_EMSSectionLabormeldung -->
   <include href="include/1.2.40.0.34.6.0.11.2.86-2020-04-22T144121.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.86-2020-04-22T144121-closed.sch"/>
   <!-- epims_entry_specimenCollection -->
   <include href="include/1.2.40.0.34.6.0.11.3.55-2020-02-20T141708.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.55-2020-02-20T141708-closed.sch"/>
   <!-- epims_entry_EMSOrganizerLabor -->
   <include href="include/1.2.40.0.34.6.0.11.3.61-2020-02-20T161229.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.61-2020-02-20T161229-closed.sch"/>
   <!-- epims_entry_caseIdentificationLabor -->
   <include href="include/1.2.40.0.34.6.0.11.3.91-2020-04-22T153159.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.91-2020-04-22T153159-closed.sch"/>
   <!-- epims_entry_notificationOrganizerLabor -->
   <include href="include/1.2.40.0.34.6.0.11.3.92-2020-04-22T153509.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.92-2020-04-22T153509-closed.sch"/>
   <!-- NotifiableCondition -->
   <include href="include/1.3.6.1.4.1.19376.1.3.1.1.1-2013-09-09T000000.sch"/>
   <!-- LaboratoryObservation -->
   <include href="include/1.3.6.1.4.1.19376.1.3.1.6-2020-06-15T085028.sch"/>

</schema>
