<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.90
Name: Device Measurement Range Observation
Description: Die Device Measurement Range Observation kann mit einem oder mehreren Elementen in einem Device Information Organizer vorhanden sein. Der Messbereich oder die Messspanne einer Messung sagt aus, in welchem Bereich ein Messwert liegen kann, um noch vom Gerät gemessen werden zu können. Beispielsweise kann der Messbereich eines Thermometers zwischen 0 und 100 Grad
                Celsius liegen. Der Messbereich wird hier in den Einheiten der Messgröße angegeben und weil ein Gerät mehr als nur eine Messgröße messen kann, können mehrere Device Measurement Range Observation-Elemente existieren. Wenn das Gerät die Daten über den Messbereich oder die anderen Geräte-Details nicht zurückgibt, können diese, wenn gewünscht, auch manuell oder über andere Wege
                eingetragen werden.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741">
   <title>Device Measurement Range Observation</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]
Item: (Device Measurement Range Observation)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]"
         id="d46e26149-false-d2019488e0">
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@classCode) = ('OBS')">(Device Measurement Range Observation): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@moodCode) = ('DEF')">(Device Measurement Range Observation): Der Wert von moodCode MUSS 'DEF' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90']) &gt;= 1">(Device Measurement Range Observation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90']) &lt;= 1">(Device Measurement Range Observation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']) &gt;= 1">(Device Measurement Range Observation): Element hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']) &lt;= 1">(Device Measurement Range Observation): Element hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]) &gt;= 1">(Device Measurement Range Observation): Element hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]) &lt;= 1">(Device Measurement Range Observation): Element hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:text[not(@nullFlavor)][hl7:reference]) &gt;= 1">(Device Measurement Range Observation): Element hl7:text[not(@nullFlavor)][hl7:reference] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:text[not(@nullFlavor)][hl7:reference]) &lt;= 1">(Device Measurement Range Observation): Element hl7:text[not(@nullFlavor)][hl7:reference] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:value[@xsi:type='IVL_PQ'] | hl7:value[@xsi:type='ST']) &gt;= 1">(Device Measurement Range Observation): Auswahl (hl7:value[@xsi:type='IVL_PQ']  oder  hl7:value[@xsi:type='ST']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:value[@xsi:type='IVL_PQ'] | hl7:value[@xsi:type='ST']) &lt;= 1">(Device Measurement Range Observation): Auswahl (hl7:value[@xsi:type='IVL_PQ']  oder  hl7:value[@xsi:type='ST']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:value[@xsi:type='IVL_PQ']) &lt;= 1">(Device Measurement Range Observation): Element hl7:value[@xsi:type='IVL_PQ'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:value[@xsi:type='ST']) &lt;= 1">(Device Measurement Range Observation): Element hl7:value[@xsi:type='ST'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90']
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90']"
         id="d46e26155-false-d2019556e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.90')">(Device Measurement Range Observation): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.90' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']"
         id="d46e26164-false-d2019571e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.36.5')">(Device Measurement Range Observation): Der Wert von root MUSS '2.16.840.1.113883.10.20.36.5' sein. Gefunden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@extension) = ('2015-08-17')">(Device Measurement Range Observation): Der Wert von extension MUSS '2015-08-17' sein. Gefunden: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Device Measurement Range Observation): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]"
         id="d46e26175-false-d2019593e0">
      <extends rule="CD.IPS"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@code) = ('67198')">(Device Measurement Range Observation): Der Wert von code MUSS '67198' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.24')">(Device Measurement Range Observation): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.24' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@codeSystemName) = ('MDC')">(Device Measurement Range Observation): Der Wert von codeSystemName MUSS 'MDC' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Device Measurement Range Observation): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="string(@displayName) = ('MDC_ATTR_NU_RANGE_MSMT: Measurement range')">(Device Measurement Range Observation): Der Wert von displayName MUSS 'MDC_ATTR_NU_RANGE_MSMT: Measurement range' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Device Measurement Range Observation): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]/hl7:translation
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]/hl7:translation"
         id="d46e26185-false-d2019631e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@code">(Device Measurement Range Observation): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Device Measurement Range Observation): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@codeSystem">(Device Measurement Range Observation): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Device Measurement Range Observation): Attribute @codeSystem MUSS vom Datentyp 'uid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Device Measurement Range Observation): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Device Measurement Range Observation): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]/ips:designation
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:code[(@code = '67198' and @codeSystem = '2.16.840.1.113883.6.24')]/ips:designation"
         id="d46e26200-false-d2019658e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@language">(Device Measurement Range Observation): Attribut @language MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@language) or (string-length(@language) &gt; 0 and not(matches(@language,'\s')))">(Device Measurement Range Observation): Attribute @language MUSS vom Datentyp 'cs' sein  - '<value-of select="@language"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)][hl7:reference]
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)][hl7:reference]"
         id="d46e26210-false-d2019674e0">
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Device Measurement Range Observation): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Device Measurement Range Observation): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)][hl7:reference]/hl7:reference[not(@nullFlavor)]
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)][hl7:reference]/hl7:reference[not(@nullFlavor)]"
         id="d46e26215-false-d2019690e0">
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@value">(Device Measurement Range Observation): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@value) or string-length(@value)&gt;0">(Device Measurement Range Observation): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='IVL_PQ']
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='IVL_PQ']"
         id="d46e26223-false-d2019701e0">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Measurement Range Observation): value/low @value ist keine gültige PQ Zahl<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Measurement Range Observation): value/high @value ist keine gültige PQ Zahl<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Measurement Range Observation): value/center @value ist keine gültige PQ Zahl<value-of select="hl7:center/@value"/>
      </assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@nullFlavor or ($xsiLocalName='IVL_PQ' and $xsiLocalNS='urn:hl7-org:v3')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:low[not(@nullFlavor)]) &gt;= 1">(Device Measurement Range Observation): Element hl7:low[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:low[not(@nullFlavor)]) &lt;= 1">(Device Measurement Range Observation): Element hl7:low[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:high[not(@nullFlavor)]) &gt;= 1">(Device Measurement Range Observation): Element hl7:high[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="count(hl7:high[not(@nullFlavor)]) &lt;= 1">(Device Measurement Range Observation): Element hl7:high[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='IVL_PQ']/hl7:low[not(@nullFlavor)]
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='IVL_PQ']/hl7:low[not(@nullFlavor)]"
         id="d46e26227-false-d2019736e0">
      <extends rule="IVXB_PQ"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVXB_PQ')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVXB_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@value">(Device Measurement Range Observation): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Measurement Range Observation): Attribute @value ist keine gültige real Zahl <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@unit">(Device Measurement Range Observation): Attribut @unit MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(Device Measurement Range Observation): Attribute @unit MUSS vom Datentyp 'cs' sein  - '<value-of select="@unit"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='IVL_PQ']/hl7:high[not(@nullFlavor)]
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='IVL_PQ']/hl7:high[not(@nullFlavor)]"
         id="d46e26243-false-d2019757e0">
      <extends rule="IVXB_PQ"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVXB_PQ')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVXB_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@value">(Device Measurement Range Observation): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Measurement Range Observation): Attribute @value ist keine gültige real Zahl <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@unit">(Device Measurement Range Observation): Attribut @unit MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(Device Measurement Range Observation): Attribute @unit MUSS vom Datentyp 'cs' sein  - '<value-of select="@unit"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.90
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='ST']
Item: (Device Measurement Range Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.90'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.5'][@extension = '2015-08-17']]/hl7:value[@xsi:type='ST']"
         id="d46e26260-false-d2019776e0">
      <extends rule="ST"/>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.90-2021-02-18T132741.html"
              test="@nullFlavor or ($xsiLocalName='ST' and $xsiLocalNS='urn:hl7-org:v3')">(Device Measurement Range Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
