<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.3.87
Name: Device Accuracy Observation
Description: Die Device Accuracy Observation kann mit einem oder mehreren Elementen in einem Device Information Organizer vorhanden sein. Die Genauigkeit oder Präzession einer Messung sagt aus wie viel der Messwert vom tatsächlichen Wert abweichen könnte. Beispielsweise können die Werte eines Geräts mit +/-3% vom tatsächlichen Wert abweichen. Die Genauigkeit wird hier
                angegeben in den Einheiten der Messgröße, und weil ein Gerät mehr als nur eine Messgröße messen kann, können mehrere Device Accuracy Observation-Elemente existieren. Wenn das Gerät die Daten über die Genauigkeit oder den anderen Geräte-Details nicht zurückgibt, können diese, wenn gewünscht, auch manuell oder über andere Wege eingetragen werden.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404">
   <title>Device Accuracy Observation</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]
Item: (Device Accuracy Observation)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]"
         id="d46e25725-false-d2018254e0">
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@classCode) = ('OBS')">(Device Accuracy Observation): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@moodCode) = ('DEF')">(Device Accuracy Observation): Der Wert von moodCode MUSS 'DEF' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87']) &gt;= 1">(Device Accuracy Observation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87']) &lt;= 1">(Device Accuracy Observation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']) &gt;= 1">(Device Accuracy Observation): Element hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']) &lt;= 1">(Device Accuracy Observation): Element hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]) &gt;= 1">(Device Accuracy Observation): Element hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]) &lt;= 1">(Device Accuracy Observation): Element hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Device Accuracy Observation): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Device Accuracy Observation): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &gt;= 1">(Device Accuracy Observation): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]) &lt;= 1">(Device Accuracy Observation): Element hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87']
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87']"
         id="d46e25731-false-d2018314e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.87')">(Device Accuracy Observation): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.87' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']"
         id="d46e25740-false-d2018329e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.36.3')">(Device Accuracy Observation): Der Wert von root MUSS '2.16.840.1.113883.10.20.36.3' sein. Gefunden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@extension) = ('2015-08-17')">(Device Accuracy Observation): Der Wert von extension MUSS '2015-08-17' sein. Gefunden: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Device Accuracy Observation): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]"
         id="d46e25751-false-d2018351e0">
      <extends rule="CD.IPS"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@code) = ('67194')">(Device Accuracy Observation): Der Wert von code MUSS '67194' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.24')">(Device Accuracy Observation): Der Wert von codeSystem MUSS '2.16.840.1.113883.6.24' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@codeSystemName) = ('MDC')">(Device Accuracy Observation): Der Wert von codeSystemName MUSS 'MDC' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Device Accuracy Observation): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="string(@displayName) = ('MDC_ATTR_NU_ACCUR_MSMT: Measurement accuracy')">(Device Accuracy Observation): Der Wert von displayName MUSS 'MDC_ATTR_NU_ACCUR_MSMT: Measurement accuracy' sein. Gefunden: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Device Accuracy Observation): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]/hl7:translation
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]/hl7:translation"
         id="d46e25761-false-d2018389e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@code">(Device Accuracy Observation): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Device Accuracy Observation): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@codeSystem">(Device Accuracy Observation): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Device Accuracy Observation): Attribute @codeSystem MUSS vom Datentyp 'uid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Device Accuracy Observation): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Device Accuracy Observation): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]/ips:designation
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:code[(@code = '67194' and @codeSystem = '2.16.840.1.113883.6.24')]/ips:designation"
         id="d46e25776-false-d2018416e0">
      <extends rule="ST"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@language">(Device Accuracy Observation): Attribut @language MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@language) or (string-length(@language) &gt; 0 and not(matches(@language,'\s')))">(Device Accuracy Observation): Attribute @language MUSS vom Datentyp 'cs' sein  - '<value-of select="@language"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)]
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)]"
         id="d46e25786-false-d2018432e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Device Accuracy Observation): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Device Accuracy Observation): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:text[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]"
         id="d46e25791-false-d2018451e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@value">(Device Accuracy Observation): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@value) or string-length(@value)&gt;0">(Device Accuracy Observation): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.87
Context: *[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]
Item: (Device Accuracy Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]]/hl7:observation[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.87'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.36.3'][@extension = '2015-08-17']]/hl7:value[not(@nullFlavor)][resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')]"
         id="d46e25797-false-d2018467e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Accuracy Observation): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Device Accuracy Observation): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@nullFlavor or ($xsiLocalName='PQ' and $xsiLocalNS='urn:hl7-org:v3')">(Device Accuracy Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@value">(Device Accuracy Observation): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Device Accuracy Observation): Attribute @value ist keine gültige real Zahl <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="@unit">(Device Accuracy Observation): Attribut @unit MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgatgd-html-20251024T110450/tmp-1.2.40.0.34.6.0.11.3.87-2021-02-18T132404.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(Device Accuracy Observation): Attribute @unit MUSS vom Datentyp 'cs' sein  - '<value-of select="@unit"/>'</assert>
   </rule>
</pattern>
