<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction Ambulanzbefund v1 (1.2.40.0.34.777.8.4.3 2023-05-09T07:32:49)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-at:v3" prefix="hl7at"/>
   <ns uri="urn:ihe:pharm" prefix="pharm"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <ns uri="urn:hl7-org:ips" prefix="ips"/>
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'Ambulanzbefund'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario Ambulanzbefund -->

   <!-- elgaambbef_document_ambulanzbefund -->
   <pattern>
      <title>elgaambbef_document_ambulanzbefund</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.22.1'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.5']]"
                 see="http://elga.art-decor.org/elgaambbef-html-20251024T104955/tmp-1.2.40.0.34.6.0.11.0.5-2022-06-07T105337.html">(Ambulanzbefund): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.22.1'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.5']]</assert>
      </rule>
   </pattern>
   <include href="include/1.2.40.0.34.6.0.11.0.5-2022-06-07T105337.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.0.5-2022-06-07T105337-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-1.2.40.0.34.6.0.11.0.5-2022-06-07T105337"/>
      <active pattern="template-1.2.40.0.34.11.1.3.1-2017-05-05T000000"/>
      <active pattern="template-1.2.40.0.34.11.13.3.13-2017-07-13T210449"/>
      <active pattern="template-1.2.40.0.34.11.13.3.18-2017-08-10T195216"/>
      <active pattern="template-1.2.40.0.34.11.13.3.19-2017-08-10T202554"/>
      <active pattern="template-1.2.40.0.34.11.13.3.21-2017-08-20T120835"/>
      <active pattern="template-1.2.40.0.34.11.13.3.6-2017-01-26T142954"/>
      <active pattern="template-1.2.40.0.34.11.13.3.7-2017-08-13T150852"/>
      <active pattern="template-1.2.40.0.34.11.8.1.3.1-2014-09-01T000000"/>
      <active pattern="template-1.2.40.0.34.11.8.2.3.1-2014-09-10T000000"/>
      <active pattern="template-1.2.40.0.34.11.8.4.3.1-2014-03-04T000000"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.1-2021-02-19T114643"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.10-2025-09-08T121702"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.11-2021-02-19T104146"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.12-2021-02-19T104156"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.13-2021-02-19T090307"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.14-2021-02-19T103551"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.16-2024-05-21T145508"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.17-2021-02-19T092953"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.19-2024-05-22T101451"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.20-2024-05-22T100110"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.21-2025-08-06T144913"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.22-2021-02-19T090241"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.23-2021-02-19T104339"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.25-2021-02-19T104512"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.26-2021-02-19T104355"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.41-2021-02-19T084624"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.42-2021-02-19T104151"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.43-2021-02-19T090640"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.44-2021-02-19T093018"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.45-2021-02-19T090340"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.46-2021-02-19T120303"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.47-2021-02-19T093000"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.48-2021-01-28T144037"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.49-2021-02-19T103539"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.50-2021-02-19T103530"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.51-2024-05-21T153717"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.52-2021-02-19T090348"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.53-2021-02-19T093025"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.54-2021-02-19T092815"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.55-2021-02-19T092947"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.56-2021-02-19T090548"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.57-2021-02-19T104138"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.58-2021-02-19T104329"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.59-2021-02-19T114024"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.60-2021-02-19T115750"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.61-2025-07-16T073256"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.62-2021-02-19T115806"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.63-2021-02-19T115029"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.64-2021-02-19T104202"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.68-2025-07-16T132358"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.69-2021-06-28T111935"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.70-2021-06-28T112503"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.71-2023-04-05T134058"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.72-2021-02-19T114054"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.73-2021-02-19T114423"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.74-2021-02-19T090717"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.8-2023-04-13T110152"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.83-2021-02-23T062526"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.88-2024-01-10T141234"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.89-2021-02-19T104533"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.9-2021-02-19T084614"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.90-2021-02-19T104512"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.94-2021-02-19T114416"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.96-2024-05-22T102021"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.97-2021-02-19T090321"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.98-2024-05-21T152134"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.100-2021-01-28T145003"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.102-2021-02-19T125910"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.103-2021-01-28T145841"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.104-2021-02-19T125919"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.11-2021-02-19T124256"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.14-2023-04-13T110204"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.19-2023-05-09T164236"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.23-2021-02-19T130106"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.24-2025-02-13T113313"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.30-2021-02-19T104636"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.31-2023-02-02T154005"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.32-2021-02-19T124110"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.33-2021-02-19T123940"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.34-2021-02-19T125610"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.35-2021-06-28T134402"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.36-2021-02-19T124249"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.37-2021-02-19T124116"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.38-2021-02-19T130038"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.39-2021-02-19T125204"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.40-2024-05-23T150255"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.41-2024-05-22T082531"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.42-2024-05-22T095300"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.43-2024-05-22T095012"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.44-2024-05-21T153303"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.45-2021-02-01T140251"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.46-2021-01-27T110027"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.47-2021-02-19T124346"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.48-2023-02-03T102536"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.49-2021-02-19T125553"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.50-2021-02-19T125214"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.51-2023-02-03T103752"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.53-2021-06-28T110849"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.6-2023-02-02T155045"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.7-2021-02-19T125533"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.72-2025-03-20T094206"/>
      <active pattern="template-1.2.40.0.34.6.0.11.9.17-2021-02-19T133615"/>
   </phase>
   <phase id="elgaambbef_document_ambulanzbefund">
      <active pattern="template-1.2.40.0.34.6.0.11.0.5-2022-06-07T105337"/>
   </phase>
   <phase id="elgaambbef_document_ambulanzbefund-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.0.5-2022-06-07T105337-closed"/>
   </phase>
   <phase id="EingebettetesObjektEntry">
      <active pattern="template-1.2.40.0.34.11.1.3.1-2017-05-05T000000"/>
   </phase>
   <phase id="ProblemStatusObservationEntry">
      <active pattern="template-1.2.40.0.34.11.13.3.13-2017-07-13T210449"/>
   </phase>
   <phase id="CriticalityObservation">
      <active pattern="template-1.2.40.0.34.11.13.3.18-2017-08-10T195216"/>
   </phase>
   <phase id="CertaintyObservation">
      <active pattern="template-1.2.40.0.34.11.13.3.19-2017-08-10T202554"/>
   </phase>
   <phase id="SeverityObservation">
      <active pattern="template-1.2.40.0.34.11.13.3.21-2017-08-20T120835"/>
   </phase>
   <phase id="GesundheitsproblemBedenkenEntry">
      <active pattern="template-1.2.40.0.34.11.13.3.6-2017-01-26T142954"/>
   </phase>
   <phase id="ProblemEntryGesundheitsproblem">
      <active pattern="template-1.2.40.0.34.11.13.3.7-2017-08-13T150852"/>
   </phase>
   <phase id="MedikationVerordnungEntryemed">
      <active pattern="template-1.2.40.0.34.11.8.1.3.1-2014-09-01T000000"/>
   </phase>
   <phase id="MedikationAbgabeEntryemed">
      <active pattern="template-1.2.40.0.34.11.8.2.3.1-2014-09-10T000000"/>
   </phase>
   <phase id="MedikationPharmazeutischeEmpfehlungEntry">
      <active pattern="template-1.2.40.0.34.11.8.4.3.1-2014-03-04T000000"/>
   </phase>
   <phase id="atcdabrr_section_ImpfungenKodiert-20210219T114643">
      <active pattern="template-1.2.40.0.34.6.0.11.2.1-2021-02-19T114643"/>
   </phase>
   <phase id="atcdabrr_section_ImpfungenKodiert-20210219T114643-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.1-2021-02-19T114643-closed"/>
   </phase>
   <phase id="elgagab_section_anamnese-20250908T121702">
      <active pattern="template-1.2.40.0.34.6.0.11.2.10-2025-09-08T121702"/>
   </phase>
   <phase id="elgagab_section_anamnese-20250908T121702-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.10-2025-09-08T121702-closed"/>
   </phase>
   <phase id="elgagab_section_diagnostikUndBefundeUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.11-2021-02-19T104146"/>
   </phase>
   <phase id="elgagab_section_diagnostikUndBefundeUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.11-2021-02-19T104146-closed"/>
   </phase>
   <phase id="elgagab_section_Verlauf">
      <active pattern="template-1.2.40.0.34.6.0.11.2.12-2021-02-19T104156"/>
   </phase>
   <phase id="elgagab_section_Verlauf-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.12-2021-02-19T104156-closed"/>
   </phase>
   <phase id="elgagab_section_durchgefuehrteMassnahmenKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.13-2021-02-19T090307"/>
   </phase>
   <phase id="elgagab_section_durchgefuehrteMassnahmenKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.13-2021-02-19T090307-closed"/>
   </phase>
   <phase id="elgagab_section_pflegemassnahmen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.14-2021-02-19T103551"/>
   </phase>
   <phase id="elgagab_section_pflegemassnahmen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.14-2021-02-19T103551-closed"/>
   </phase>
   <phase id="elgagab_section_FruehereErkrankungenMassnahmenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.16-2024-05-21T145508"/>
   </phase>
   <phase id="elgagab_section_FruehereErkrankungenMassnahmenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.16-2024-05-21T145508-closed"/>
   </phase>
   <phase id="elgagab_section_KonsultUeberweisungsgrundUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.17-2021-02-19T092953"/>
   </phase>
   <phase id="elgagab_section_KonsultUeberweisungsgrundUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.17-2021-02-19T092953-closed"/>
   </phase>
   <phase id="elgagab_section_FachspezifischeDiagnostik">
      <active pattern="template-1.2.40.0.34.6.0.11.2.19-2024-05-22T101451"/>
   </phase>
   <phase id="elgagab_section_FachspezifischeDiagnostik-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.19-2024-05-22T101451-closed"/>
   </phase>
   <phase id="elgagab_section_Status">
      <active pattern="template-1.2.40.0.34.6.0.11.2.20-2024-05-22T100110"/>
   </phase>
   <phase id="elgagab_section_Status-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.20-2024-05-22T100110-closed"/>
   </phase>
   <phase id="elgagab_section_EmpfohleneMedikationKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.21-2025-08-06T144913"/>
   </phase>
   <phase id="elgagab_section_EmpfohleneMedikationKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.21-2025-08-06T144913-closed"/>
   </phase>
   <phase id="elgagab_section_durchgefuehrteMassnahmenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.22-2021-02-19T090241"/>
   </phase>
   <phase id="elgagab_section_durchgefuehrteMassnahmenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.22-2021-02-19T090241-closed"/>
   </phase>
   <phase id="elgagab_section_weitereEmpfohleneMassnahmenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.23-2021-02-19T104339"/>
   </phase>
   <phase id="elgagab_section_weitereEmpfohleneMassnahmenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.23-2021-02-19T104339-closed"/>
   </phase>
   <phase id="elgagab_section_ZusammenfassendeBeurteilung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.25-2021-02-19T104512"/>
   </phase>
   <phase id="elgagab_section_ZusammenfassendeBeurteilung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.25-2021-02-19T104512-closed"/>
   </phase>
   <phase id="elgagab_section_WeitereInformationen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.26-2021-02-19T104355"/>
   </phase>
   <phase id="elgagab_section_WeitereInformationen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.26-2021-02-19T104355-closed"/>
   </phase>
   <phase id="elgagab_section_allergienIntoleranzenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.41-2021-02-19T084624"/>
   </phase>
   <phase id="elgagab_section_allergienIntoleranzenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.41-2021-02-19T084624-closed"/>
   </phase>
   <phase id="elgagab_section_TermineKontrollenWiederbestellungen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.42-2021-02-19T104151"/>
   </phase>
   <phase id="elgagab_section_TermineKontrollenWiederbestellungen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.42-2021-02-19T104151-closed"/>
   </phase>
   <phase id="elgagab_section_geplanteUntersuchungen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.43-2021-02-19T090640"/>
   </phase>
   <phase id="elgagab_section_geplanteUntersuchungen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.43-2021-02-19T090640-closed"/>
   </phase>
   <phase id="elgagab_section_konservativeTherapie">
      <active pattern="template-1.2.40.0.34.6.0.11.2.44-2021-02-19T093018"/>
   </phase>
   <phase id="elgagab_section_konservativeTherapie-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.44-2021-02-19T093018-closed"/>
   </phase>
   <phase id="elgagab_section_chirurgischeTherapie">
      <active pattern="template-1.2.40.0.34.6.0.11.2.45-2021-02-19T090340"/>
   </phase>
   <phase id="elgagab_section_chirurgischeTherapie-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.45-2021-02-19T090340-closed"/>
   </phase>
   <phase id="atcdabrr_section_VitalparameterKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.46-2021-02-19T120303"/>
   </phase>
   <phase id="atcdabrr_section_VitalparameterKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.46-2021-02-19T120303-closed"/>
   </phase>
   <phase id="elgagab_section_KonsultUeberweisungsgrundKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.47-2021-02-19T093000"/>
   </phase>
   <phase id="elgagab_section_KonsultUeberweisungsgrundKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.47-2021-02-19T093000-closed"/>
   </phase>
   <phase id="atcdabrr_section_SchwangerschaftenKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.48-2021-01-28T144037"/>
   </phase>
   <phase id="atcdabrr_section_SchwangerschaftenKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.48-2021-01-28T144037-closed"/>
   </phase>
   <phase id="elgagab_section_SchwangerschaftenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.49-2021-02-19T103539"/>
   </phase>
   <phase id="elgagab_section_SchwangerschaftenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.49-2021-02-19T103539-closed"/>
   </phase>
   <phase id="elgagab_section_ImplantateUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.50-2021-02-19T103530"/>
   </phase>
   <phase id="elgagab_section_ImplantateUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.50-2021-02-19T103530-closed"/>
   </phase>
   <phase id="cdagab_section_BeeintraechtigungenKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.51-2024-05-21T153717"/>
   </phase>
   <phase id="cdagab_section_BeeintraechtigungenKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.51-2024-05-21T153717-closed"/>
   </phase>
   <phase id="elgagab_section_BeeintraechtigungenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.52-2021-02-19T090348"/>
   </phase>
   <phase id="elgagab_section_BeeintraechtigungenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.52-2021-02-19T090348-closed"/>
   </phase>
   <phase id="elgagab_section_ImpfungenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.53-2021-02-19T093025"/>
   </phase>
   <phase id="elgagab_section_ImpfungenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.53-2021-02-19T093025-closed"/>
   </phase>
   <phase id="elgagab_section_LebensstilUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.54-2021-02-19T092815"/>
   </phase>
   <phase id="elgagab_section_LebensstilUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.54-2021-02-19T092815-closed"/>
   </phase>
   <phase id="elgagab_section_LebensstilKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.55-2021-02-19T092947"/>
   </phase>
   <phase id="elgagab_section_LebensstilKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.55-2021-02-19T092947-closed"/>
   </phase>
   <phase id="elgagab_section_EmpfohleneMedikationUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.56-2021-02-19T090548"/>
   </phase>
   <phase id="elgagab_section_EmpfohleneMedikationUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.56-2021-02-19T090548-closed"/>
   </phase>
   <phase id="elgagab_section_diagnostikUndBefundeKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.57-2021-02-19T104138"/>
   </phase>
   <phase id="elgagab_section_diagnostikUndBefundeKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.57-2021-02-19T104138-closed"/>
   </phase>
   <phase id="elgagab_section_WeitereEmpfohleneMassnahmenKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.58-2021-02-19T104329"/>
   </phase>
   <phase id="elgagab_section_WeitereEmpfohleneMassnahmenKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.58-2021-02-19T104329-closed"/>
   </phase>
   <phase id="atcdabrr_section_AllergienUndIntoleranzenKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.59-2021-02-19T114024"/>
   </phase>
   <phase id="atcdabrr_section_MedizinischeGeraeteUndImplantateKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.60-2021-02-19T115750"/>
   </phase>
   <phase id="atcdabrr_section_MedizinischeGeraeteUndImplantateKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.60-2021-02-19T115750-closed"/>
   </phase>
   <phase id="atcdabrr_section_WillenserklaerungenUndAndereJuridischeDokumente">
      <active pattern="template-1.2.40.0.34.6.0.11.2.61-2025-07-16T073256"/>
   </phase>
   <phase id="atcdabrr_section_WillenserklaerungenUndAndereJuridischeDokumente-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.61-2025-07-16T073256-closed"/>
   </phase>
   <phase id="atcdabrr_section_SUBWillenserklaerungenUndAndereJuridischeDokumente">
      <active pattern="template-1.2.40.0.34.6.0.11.2.62-2021-02-19T115806"/>
   </phase>
   <phase id="atcdabrr_section_SUBWillenserklaerungenUndAndereJuridischeDokumente-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.62-2021-02-19T115806-closed"/>
   </phase>
   <phase id="atcdabbr_section_MedikationslistePSKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.63-2021-02-19T115029"/>
   </phase>
   <phase id="atcdabbr_section_MedikationslistePSKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.63-2021-02-19T115029-closed"/>
   </phase>
   <phase id="elgagab_section_VerlaufSUBUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.64-2021-02-19T104202"/>
   </phase>
   <phase id="elgagab_section_VerlaufSUBUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.64-2021-02-19T104202-closed"/>
   </phase>
   <phase id="atcdabbr_section_VitalparameterUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.68-2025-07-16T132358"/>
   </phase>
   <phase id="atcdabbr_section_VitalparameterUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.68-2025-07-16T132358-closed"/>
   </phase>
   <phase id="atcdabbr_section_Brieftext">
      <active pattern="template-1.2.40.0.34.6.0.11.2.69-2021-06-28T111935"/>
   </phase>
   <phase id="atcdabbr_section_Brieftext-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.69-2021-06-28T111935-closed"/>
   </phase>
   <phase id="atcdabbr_section_AbschliessendeBemerkung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.70-2021-06-28T112503"/>
   </phase>
   <phase id="atcdabbr_section_AbschliessendeBemerkung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.70-2021-06-28T112503-closed"/>
   </phase>
   <phase id="atcdabbr_section_Beilagen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.71-2023-04-05T134058"/>
   </phase>
   <phase id="atcdabbr_section_Beilagen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.71-2023-04-05T134058-closed"/>
   </phase>
   <phase id="atcdabrr_section_AusstehendeBefunde">
      <active pattern="template-1.2.40.0.34.6.0.11.2.72-2021-02-19T114054"/>
   </phase>
   <phase id="atcdabrr_section_AusstehendeBefunde-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.72-2021-02-19T114054-closed"/>
   </phase>
   <phase id="atcdabbr_section_EmpfohleneAnordnungenPflege">
      <active pattern="template-1.2.40.0.34.6.0.11.2.73-2021-02-19T114423"/>
   </phase>
   <phase id="atcdabbr_section_EmpfohleneAnordnungenPflege-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.73-2021-02-19T114423-closed"/>
   </phase>
   <phase id="elgagab_section_FruehereErkrankungenMassnahmenICD10Kodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.74-2021-02-19T090717"/>
   </phase>
   <phase id="elgagab_section_FruehereErkrankungenMassnahmenICD10Kodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.74-2021-02-19T090717-closed"/>
   </phase>
   <phase id="atcdabbr_section_Uebersetzung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.8-2023-04-13T110152"/>
   </phase>
   <phase id="atcdabbr_section_Uebersetzung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.8-2023-04-13T110152-closed"/>
   </phase>
   <phase id="atcdabbr_section_DiagnoseUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.83-2021-02-23T062526"/>
   </phase>
   <phase id="atcdabbr_section_DiagnoseUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.83-2021-02-23T062526-closed"/>
   </phase>
   <phase id="elgagab_section_ZusaetzlicheMedikationUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.88-2024-01-10T141234"/>
   </phase>
   <phase id="elgagab_section_ZusaetzlicheMedikationUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.88-2024-01-10T141234-closed"/>
   </phase>
   <phase id="elgagab_section_AenderungBestehenderMedikationKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.89-2021-02-19T104533"/>
   </phase>
   <phase id="elgagab_section_AenderungBestehenderMedikationKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.89-2021-02-19T104533-closed"/>
   </phase>
   <phase id="elgagab_section_AktuelleMedikationUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.9-2021-02-19T084614"/>
   </phase>
   <phase id="elgagab_section_AktuelleMedikationUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.9-2021-02-19T084614-closed"/>
   </phase>
   <phase id="elgagab_section_ZusaetzlicheMedikationKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.90-2021-02-19T104512"/>
   </phase>
   <phase id="elgagab_section_ZusaetzlicheMedikationKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.90-2021-02-19T104512-closed"/>
   </phase>
   <phase id="atcdabbr_section_DokumentierteEinnahmeKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.94-2021-02-19T114416"/>
   </phase>
   <phase id="atcdabbr_section_DokumentierteEinnahmeKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.94-2021-02-19T114416-closed"/>
   </phase>
   <phase id="atcdabbr_section_DiagnoseKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.96-2024-05-22T102021"/>
   </phase>
   <phase id="atcdabbr_section_DiagnoseKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.96-2024-05-22T102021-closed"/>
   </phase>
   <phase id="atcdabbr_section_DokumentierteEinnahmeUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.97-2021-02-19T090321"/>
   </phase>
   <phase id="atcdabbr_section_DokumentierteEinnahmeUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.97-2021-02-19T090321-closed"/>
   </phase>
   <phase id="elgagab_section_FachspezifischeAnamnese">
      <active pattern="template-1.2.40.0.34.6.0.11.2.98-2024-05-21T152134"/>
   </phase>
   <phase id="elgagab_section_FachspezifischeAnamnese-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.98-2024-05-21T152134-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungVitalparameterEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.100-2021-01-28T145003"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungVitalparameterEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.100-2021-01-28T145003-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungsGruppeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.102-2021-02-19T125910"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungsGruppeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.102-2021-02-19T125910-closed"/>
   </phase>
   <phase id="SerienmessungsWerteEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.103-2021-01-28T145841"/>
   </phase>
   <phase id="SerienmessungsWerteEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.103-2021-01-28T145841-closed"/>
   </phase>
   <phase id="SerienmessungsPeriodeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.104-2021-02-19T125919"/>
   </phase>
   <phase id="SerienmessungsPeriodeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.104-2021-02-19T125919-closed"/>
   </phase>
   <phase id="atcdabrr_entry_Comment">
      <active pattern="template-1.2.40.0.34.6.0.11.3.11-2021-02-19T124256"/>
   </phase>
   <phase id="atcdabrr_entry_Comment-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.11-2021-02-19T124256-closed"/>
   </phase>
   <phase id="atcdabbr_entry_externalDocument">
      <active pattern="template-1.2.40.0.34.6.0.11.3.14-2023-04-13T110204"/>
   </phase>
   <phase id="atcdabbr_entry_externalDocument-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.14-2023-04-13T110204-closed"/>
   </phase>
   <phase id="atcdabbr_entry_EingebettetesObjektEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.19-2023-05-09T164236"/>
   </phase>
   <phase id="atcdabbr_entry_EingebettetesObjektEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.19-2023-05-09T164236-closed"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterGruppeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.23-2021-02-19T130106"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterGruppeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.23-2021-02-19T130106-closed"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.24-2025-02-13T113313"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.24-2025-02-13T113313-closed"/>
   </phase>
   <phase id="elgagab_entry_Konsultationsgrund">
      <active pattern="template-1.2.40.0.34.6.0.11.3.30-2021-02-19T104636"/>
   </phase>
   <phase id="elgagab_entry_Konsultationsgrund-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.30-2021-02-19T104636-closed"/>
   </phase>
   <phase id="elgagab_entry_KonsultationsgrundProblem">
      <active pattern="template-1.2.40.0.34.6.0.11.3.31-2023-02-02T154005"/>
   </phase>
   <phase id="elgagab_entry_KonsultationsgrundProblem-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.31-2023-02-02T154005-closed"/>
   </phase>
   <phase id="atcdabbr_entry_AllergyOrIntoleranceConcern">
      <active pattern="template-1.2.40.0.34.6.0.11.3.32-2021-02-19T124110"/>
   </phase>
   <phase id="atcdabbr_entry_AllergyOrIntolerance">
      <active pattern="template-1.2.40.0.34.6.0.11.3.33-2021-02-19T123940"/>
   </phase>
   <phase id="atcdabbr_entry_ReactionManifestation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.34-2021-02-19T125610"/>
   </phase>
   <phase id="atcdabbr_entry_ReactionManifestation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.34-2021-02-19T125610-closed"/>
   </phase>
   <phase id="atcdabbr_entry_CriticalityObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.35-2021-06-28T134402"/>
   </phase>
   <phase id="atcdabbr_entry_CriticalityObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.35-2021-06-28T134402-closed"/>
   </phase>
   <phase id="atcdabbr_entry_CertaintyObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.36-2021-02-19T124249"/>
   </phase>
   <phase id="atcdabbr_entry_CertaintyObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.36-2021-02-19T124249-closed"/>
   </phase>
   <phase id="atcdabbr_entry_AllergyStatusObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.37-2021-02-19T124116"/>
   </phase>
   <phase id="atcdabbr_entry_AllergyStatusObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.37-2021-02-19T124116-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SeverityObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.38-2021-02-19T130038"/>
   </phase>
   <phase id="atcdabbr_entry_SeverityObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.38-2021-02-19T130038-closed"/>
   </phase>
   <phase id="atcdabbr_entry_MedicalDevice">
      <active pattern="template-1.2.40.0.34.6.0.11.3.39-2021-02-19T125204"/>
   </phase>
   <phase id="atcdabbr_entry_MedicalDevice-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.39-2021-02-19T125204-closed"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilTabakkonsumQuantitativ">
      <active pattern="template-1.2.40.0.34.6.0.11.3.40-2024-05-23T150255"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilTabakkonsumQuantitativ-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.40-2024-05-23T150255-closed"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilTabakkonsumNominal">
      <active pattern="template-1.2.40.0.34.6.0.11.3.41-2024-05-22T082531"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilAlkoholkonsumQuantitativ">
      <active pattern="template-1.2.40.0.34.6.0.11.3.42-2024-05-22T095300"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilAlkoholkonsumQuantitativ-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.42-2024-05-22T095300-closed"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilAlkoholkonsumNominal">
      <active pattern="template-1.2.40.0.34.6.0.11.3.43-2024-05-22T095012"/>
   </phase>
   <phase id="atcdabbr_entry_LebensstilAlkoholkonsumNominal-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.43-2024-05-22T095012-closed"/>
   </phase>
   <phase id="atcdabbr_entry_AktuelleSchwangerschaft">
      <active pattern="template-1.2.40.0.34.6.0.11.3.44-2024-05-21T153303"/>
   </phase>
   <phase id="atcdabbr_entry_AktuelleSchwangerschaft-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.44-2024-05-21T153303-closed"/>
   </phase>
   <phase id="atcdabbr_entry_ErwartetesGeburtsdatum">
      <active pattern="template-1.2.40.0.34.6.0.11.3.45-2021-02-01T140251"/>
   </phase>
   <phase id="atcdabbr_entry_ErwartetesGeburtsdatum-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.45-2021-02-01T140251-closed"/>
   </phase>
   <phase id="atcdabbr_entry_BisherigeSchwangerschaften">
      <active pattern="template-1.2.40.0.34.6.0.11.3.46-2021-01-27T110027"/>
   </phase>
   <phase id="atcdabbr_entry_BisherigeSchwangerschaften-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.46-2021-01-27T110027-closed"/>
   </phase>
   <phase id="atcdabbr_entry_FunctionalStatus">
      <active pattern="template-1.2.40.0.34.6.0.11.3.47-2021-02-19T124346"/>
   </phase>
   <phase id="atcdabbr_entry_FunctionalStatus-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.47-2021-02-19T124346-closed"/>
   </phase>
   <phase id="ELGA_HistoryOfProcedures">
      <active pattern="template-1.2.40.0.34.6.0.11.3.48-2023-02-03T102536"/>
   </phase>
   <phase id="ELGA_HistoryOfProcedures-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.48-2023-02-03T102536-closed"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemStatusObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.49-2021-02-19T125553"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemStatusObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.49-2021-02-19T125553-closed"/>
   </phase>
   <phase id="atcdabbr_entry_MedicationStatement">
      <active pattern="template-1.2.40.0.34.6.0.11.3.50-2021-02-19T125214"/>
   </phase>
   <phase id="atcdabbr_entry_MedicationStatement-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.50-2021-02-19T125214-closed"/>
   </phase>
   <phase id="atcdabbr_entry_Procedure">
      <active pattern="template-1.2.40.0.34.6.0.11.3.51-2023-02-03T103752"/>
   </phase>
   <phase id="atcdabbr_entry_Procedure-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.51-2023-02-03T103752-closed"/>
   </phase>
   <phase id="atcdabbr_entry_Logo">
      <active pattern="template-1.2.40.0.34.6.0.11.3.53-2021-06-28T110849"/>
   </phase>
   <phase id="atcdabbr_entry_Logo-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.53-2021-06-28T110849-closed"/>
   </phase>
   <phase id="atcdabbr_entry_Problem">
      <active pattern="template-1.2.40.0.34.6.0.11.3.6-2023-02-02T155045"/>
   </phase>
   <phase id="atcdabbr_entry_Problem-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.6-2023-02-02T155045-closed"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemConcern">
      <active pattern="template-1.2.40.0.34.6.0.11.3.7-2021-02-19T125533"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemConcern-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.7-2021-02-19T125533-closed"/>
   </phase>
   <phase id="atcdabbr_entry_MedikationsEinnahmeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.72-2025-03-20T094206"/>
   </phase>
   <phase id="atcdabbr_entry_MedikationsEinnahmeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.72-2025-03-20T094206-closed"/>
   </phase>
   <phase id="atcdabbr_other_PerformerBody">
      <active pattern="template-1.2.40.0.34.6.0.11.9.17-2021-02-19T133615"/>
   </phase>
   <phase id="atcdabbr_other_PerformerBody-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.9.17-2021-02-19T133615-closed"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- EingebettetesObjektEntry -->
   <include href="include/1.2.40.0.34.11.1.3.1-2017-05-05T000000.sch"/>
   <!-- ProblemStatusObservationEntry -->
   <include href="include/1.2.40.0.34.11.13.3.13-2017-07-13T210449.sch"/>
   <!-- CriticalityObservation -->
   <include href="include/1.2.40.0.34.11.13.3.18-2017-08-10T195216.sch"/>
   <!-- CertaintyObservation -->
   <include href="include/1.2.40.0.34.11.13.3.19-2017-08-10T202554.sch"/>
   <!-- SeverityObservation -->
   <include href="include/1.2.40.0.34.11.13.3.21-2017-08-20T120835.sch"/>
   <!-- GesundheitsproblemBedenkenEntry -->
   <include href="include/1.2.40.0.34.11.13.3.6-2017-01-26T142954.sch"/>
   <!-- ProblemEntryGesundheitsproblem -->
   <include href="include/1.2.40.0.34.11.13.3.7-2017-08-13T150852.sch"/>
   <!-- MedikationVerordnungEntryemed -->
   <include href="include/1.2.40.0.34.11.8.1.3.1-2014-09-01T000000.sch"/>
   <!-- MedikationAbgabeEntryemed -->
   <include href="include/1.2.40.0.34.11.8.2.3.1-2014-09-10T000000.sch"/>
   <!-- MedikationPharmazeutischeEmpfehlungEntry -->
   <include href="include/1.2.40.0.34.11.8.4.3.1-2014-03-04T000000.sch"/>
   <!-- atcdabrr_section_ImpfungenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.1-2021-02-19T114643.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.1-2021-02-19T114643-closed.sch"/>
   <!-- elgagab_section_anamnese -->
   <include href="include/1.2.40.0.34.6.0.11.2.10-2025-09-08T121702.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.10-2025-09-08T121702-closed.sch"/>
   <!-- elgagab_section_diagnostikUndBefundeUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.11-2021-02-19T104146.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.11-2021-02-19T104146-closed.sch"/>
   <!-- elgagab_section_Verlauf -->
   <include href="include/1.2.40.0.34.6.0.11.2.12-2021-02-19T104156.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.12-2021-02-19T104156-closed.sch"/>
   <!-- elgagab_section_durchgefuehrteMassnahmenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.13-2021-02-19T090307.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.13-2021-02-19T090307-closed.sch"/>
   <!-- elgagab_section_pflegemassnahmen -->
   <include href="include/1.2.40.0.34.6.0.11.2.14-2021-02-19T103551.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.14-2021-02-19T103551-closed.sch"/>
   <!-- elgagab_section_FruehereErkrankungenMassnahmenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.16-2024-05-21T145508.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.16-2024-05-21T145508-closed.sch"/>
   <!-- elgagab_section_KonsultUeberweisungsgrundUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.17-2021-02-19T092953.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.17-2021-02-19T092953-closed.sch"/>
   <!-- elgagab_section_FachspezifischeDiagnostik -->
   <include href="include/1.2.40.0.34.6.0.11.2.19-2024-05-22T101451.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.19-2024-05-22T101451-closed.sch"/>
   <!-- elgagab_section_Status -->
   <include href="include/1.2.40.0.34.6.0.11.2.20-2024-05-22T100110.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.20-2024-05-22T100110-closed.sch"/>
   <!-- elgagab_section_EmpfohleneMedikationKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.21-2025-08-06T144913.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.21-2025-08-06T144913-closed.sch"/>
   <!-- elgagab_section_durchgefuehrteMassnahmenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.22-2021-02-19T090241.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.22-2021-02-19T090241-closed.sch"/>
   <!-- elgagab_section_weitereEmpfohleneMassnahmenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.23-2021-02-19T104339.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.23-2021-02-19T104339-closed.sch"/>
   <!-- elgagab_section_ZusammenfassendeBeurteilung -->
   <include href="include/1.2.40.0.34.6.0.11.2.25-2021-02-19T104512.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.25-2021-02-19T104512-closed.sch"/>
   <!-- elgagab_section_WeitereInformationen -->
   <include href="include/1.2.40.0.34.6.0.11.2.26-2021-02-19T104355.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.26-2021-02-19T104355-closed.sch"/>
   <!-- elgagab_section_allergienIntoleranzenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.41-2021-02-19T084624.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.41-2021-02-19T084624-closed.sch"/>
   <!-- elgagab_section_TermineKontrollenWiederbestellungen -->
   <include href="include/1.2.40.0.34.6.0.11.2.42-2021-02-19T104151.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.42-2021-02-19T104151-closed.sch"/>
   <!-- elgagab_section_geplanteUntersuchungen -->
   <include href="include/1.2.40.0.34.6.0.11.2.43-2021-02-19T090640.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.43-2021-02-19T090640-closed.sch"/>
   <!-- elgagab_section_konservativeTherapie -->
   <include href="include/1.2.40.0.34.6.0.11.2.44-2021-02-19T093018.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.44-2021-02-19T093018-closed.sch"/>
   <!-- elgagab_section_chirurgischeTherapie -->
   <include href="include/1.2.40.0.34.6.0.11.2.45-2021-02-19T090340.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.45-2021-02-19T090340-closed.sch"/>
   <!-- atcdabrr_section_VitalparameterKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.46-2021-02-19T120303.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.46-2021-02-19T120303-closed.sch"/>
   <!-- elgagab_section_KonsultUeberweisungsgrundKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.47-2021-02-19T093000.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.47-2021-02-19T093000-closed.sch"/>
   <!-- atcdabrr_section_SchwangerschaftenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.48-2021-01-28T144037.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.48-2021-01-28T144037-closed.sch"/>
   <!-- elgagab_section_SchwangerschaftenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.49-2021-02-19T103539.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.49-2021-02-19T103539-closed.sch"/>
   <!-- elgagab_section_ImplantateUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.50-2021-02-19T103530.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.50-2021-02-19T103530-closed.sch"/>
   <!-- cdagab_section_BeeintraechtigungenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.51-2024-05-21T153717.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.51-2024-05-21T153717-closed.sch"/>
   <!-- elgagab_section_BeeintraechtigungenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.52-2021-02-19T090348.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.52-2021-02-19T090348-closed.sch"/>
   <!-- elgagab_section_ImpfungenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.53-2021-02-19T093025.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.53-2021-02-19T093025-closed.sch"/>
   <!-- elgagab_section_LebensstilUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.54-2021-02-19T092815.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.54-2021-02-19T092815-closed.sch"/>
   <!-- elgagab_section_LebensstilKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.55-2021-02-19T092947.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.55-2021-02-19T092947-closed.sch"/>
   <!-- elgagab_section_EmpfohleneMedikationUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.56-2021-02-19T090548.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.56-2021-02-19T090548-closed.sch"/>
   <!-- elgagab_section_diagnostikUndBefundeKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.57-2021-02-19T104138.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.57-2021-02-19T104138-closed.sch"/>
   <!-- elgagab_section_WeitereEmpfohleneMassnahmenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.58-2021-02-19T104329.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.58-2021-02-19T104329-closed.sch"/>
   <!-- atcdabrr_section_AllergienUndIntoleranzenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.59-2021-02-19T114024.sch"/>
   <!-- atcdabrr_section_MedizinischeGeraeteUndImplantateKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.60-2021-02-19T115750.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.60-2021-02-19T115750-closed.sch"/>
   <!-- atcdabrr_section_WillenserklaerungenUndAndereJuridischeDokumente -->
   <include href="include/1.2.40.0.34.6.0.11.2.61-2025-07-16T073256.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.61-2025-07-16T073256-closed.sch"/>
   <!-- atcdabrr_section_SUBWillenserklaerungenUndAndereJuridischeDokumente -->
   <include href="include/1.2.40.0.34.6.0.11.2.62-2021-02-19T115806.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.62-2021-02-19T115806-closed.sch"/>
   <!-- atcdabbr_section_MedikationslistePSKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.63-2021-02-19T115029.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.63-2021-02-19T115029-closed.sch"/>
   <!-- elgagab_section_VerlaufSUBUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.64-2021-02-19T104202.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.64-2021-02-19T104202-closed.sch"/>
   <!-- atcdabbr_section_VitalparameterUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.68-2025-07-16T132358.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.68-2025-07-16T132358-closed.sch"/>
   <!-- atcdabbr_section_Brieftext -->
   <include href="include/1.2.40.0.34.6.0.11.2.69-2021-06-28T111935.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.69-2021-06-28T111935-closed.sch"/>
   <!-- atcdabbr_section_AbschliessendeBemerkung -->
   <include href="include/1.2.40.0.34.6.0.11.2.70-2021-06-28T112503.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.70-2021-06-28T112503-closed.sch"/>
   <!-- atcdabbr_section_Beilagen -->
   <include href="include/1.2.40.0.34.6.0.11.2.71-2023-04-05T134058.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.71-2023-04-05T134058-closed.sch"/>
   <!-- atcdabrr_section_AusstehendeBefunde -->
   <include href="include/1.2.40.0.34.6.0.11.2.72-2021-02-19T114054.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.72-2021-02-19T114054-closed.sch"/>
   <!-- atcdabbr_section_EmpfohleneAnordnungenPflege -->
   <include href="include/1.2.40.0.34.6.0.11.2.73-2021-02-19T114423.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.73-2021-02-19T114423-closed.sch"/>
   <!-- elgagab_section_FruehereErkrankungenMassnahmenICD10Kodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.74-2021-02-19T090717.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.74-2021-02-19T090717-closed.sch"/>
   <!-- atcdabbr_section_Uebersetzung -->
   <include href="include/1.2.40.0.34.6.0.11.2.8-2023-04-13T110152.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.8-2023-04-13T110152-closed.sch"/>
   <!-- atcdabbr_section_DiagnoseUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.83-2021-02-23T062526.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.83-2021-02-23T062526-closed.sch"/>
   <!-- elgagab_section_ZusaetzlicheMedikationUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.88-2024-01-10T141234.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.88-2024-01-10T141234-closed.sch"/>
   <!-- elgagab_section_AenderungBestehenderMedikationKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.89-2021-02-19T104533.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.89-2021-02-19T104533-closed.sch"/>
   <!-- elgagab_section_AktuelleMedikationUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.9-2021-02-19T084614.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.9-2021-02-19T084614-closed.sch"/>
   <!-- elgagab_section_ZusaetzlicheMedikationKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.90-2021-02-19T104512.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.90-2021-02-19T104512-closed.sch"/>
   <!-- atcdabbr_section_DokumentierteEinnahmeKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.94-2021-02-19T114416.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.94-2021-02-19T114416-closed.sch"/>
   <!-- atcdabbr_section_DiagnoseKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.96-2024-05-22T102021.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.96-2024-05-22T102021-closed.sch"/>
   <!-- atcdabbr_section_DokumentierteEinnahmeUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.97-2021-02-19T090321.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.97-2021-02-19T090321-closed.sch"/>
   <!-- elgagab_section_FachspezifischeAnamnese -->
   <include href="include/1.2.40.0.34.6.0.11.2.98-2024-05-21T152134.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.98-2024-05-21T152134-closed.sch"/>
   <!-- atcdabbr_entry_SerienmessungVitalparameterEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.100-2021-01-28T145003.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.100-2021-01-28T145003-closed.sch"/>
   <!-- atcdabbr_entry_SerienmessungsGruppeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.102-2021-02-19T125910.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.102-2021-02-19T125910-closed.sch"/>
   <!-- SerienmessungsWerteEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.103-2021-01-28T145841.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.103-2021-01-28T145841-closed.sch"/>
   <!-- SerienmessungsPeriodeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.104-2021-02-19T125919.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.104-2021-02-19T125919-closed.sch"/>
   <!-- atcdabrr_entry_Comment -->
   <include href="include/1.2.40.0.34.6.0.11.3.11-2021-02-19T124256.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.11-2021-02-19T124256-closed.sch"/>
   <!-- atcdabbr_entry_externalDocument -->
   <include href="include/1.2.40.0.34.6.0.11.3.14-2023-04-13T110204.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.14-2023-04-13T110204-closed.sch"/>
   <!-- atcdabbr_entry_EingebettetesObjektEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.19-2023-05-09T164236.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.19-2023-05-09T164236-closed.sch"/>
   <!-- atcdabbr_entry_VitalparameterGruppeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.23-2021-02-19T130106.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.23-2021-02-19T130106-closed.sch"/>
   <!-- atcdabbr_entry_VitalparameterEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.24-2025-02-13T113313.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.24-2025-02-13T113313-closed.sch"/>
   <!-- elgagab_entry_Konsultationsgrund -->
   <include href="include/1.2.40.0.34.6.0.11.3.30-2021-02-19T104636.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.30-2021-02-19T104636-closed.sch"/>
   <!-- elgagab_entry_KonsultationsgrundProblem -->
   <include href="include/1.2.40.0.34.6.0.11.3.31-2023-02-02T154005.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.31-2023-02-02T154005-closed.sch"/>
   <!-- atcdabbr_entry_AllergyOrIntoleranceConcern -->
   <include href="include/1.2.40.0.34.6.0.11.3.32-2021-02-19T124110.sch"/>
   <!-- atcdabbr_entry_AllergyOrIntolerance -->
   <include href="include/1.2.40.0.34.6.0.11.3.33-2021-02-19T123940.sch"/>
   <!-- atcdabbr_entry_ReactionManifestation -->
   <include href="include/1.2.40.0.34.6.0.11.3.34-2021-02-19T125610.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.34-2021-02-19T125610-closed.sch"/>
   <!-- atcdabbr_entry_CriticalityObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.35-2021-06-28T134402.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.35-2021-06-28T134402-closed.sch"/>
   <!-- atcdabbr_entry_CertaintyObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.36-2021-02-19T124249.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.36-2021-02-19T124249-closed.sch"/>
   <!-- atcdabbr_entry_AllergyStatusObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.37-2021-02-19T124116.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.37-2021-02-19T124116-closed.sch"/>
   <!-- atcdabbr_entry_SeverityObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.38-2021-02-19T130038.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.38-2021-02-19T130038-closed.sch"/>
   <!-- atcdabbr_entry_MedicalDevice -->
   <include href="include/1.2.40.0.34.6.0.11.3.39-2021-02-19T125204.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.39-2021-02-19T125204-closed.sch"/>
   <!-- atcdabbr_entry_LebensstilTabakkonsumQuantitativ -->
   <include href="include/1.2.40.0.34.6.0.11.3.40-2024-05-23T150255.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.40-2024-05-23T150255-closed.sch"/>
   <!-- atcdabbr_entry_LebensstilTabakkonsumNominal -->
   <include href="include/1.2.40.0.34.6.0.11.3.41-2024-05-22T082531.sch"/>
   <!-- atcdabbr_entry_LebensstilAlkoholkonsumQuantitativ -->
   <include href="include/1.2.40.0.34.6.0.11.3.42-2024-05-22T095300.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.42-2024-05-22T095300-closed.sch"/>
   <!-- atcdabbr_entry_LebensstilAlkoholkonsumNominal -->
   <include href="include/1.2.40.0.34.6.0.11.3.43-2024-05-22T095012.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.43-2024-05-22T095012-closed.sch"/>
   <!-- atcdabbr_entry_AktuelleSchwangerschaft -->
   <include href="include/1.2.40.0.34.6.0.11.3.44-2024-05-21T153303.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.44-2024-05-21T153303-closed.sch"/>
   <!-- atcdabbr_entry_ErwartetesGeburtsdatum -->
   <include href="include/1.2.40.0.34.6.0.11.3.45-2021-02-01T140251.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.45-2021-02-01T140251-closed.sch"/>
   <!-- atcdabbr_entry_BisherigeSchwangerschaften -->
   <include href="include/1.2.40.0.34.6.0.11.3.46-2021-01-27T110027.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.46-2021-01-27T110027-closed.sch"/>
   <!-- atcdabbr_entry_FunctionalStatus -->
   <include href="include/1.2.40.0.34.6.0.11.3.47-2021-02-19T124346.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.47-2021-02-19T124346-closed.sch"/>
   <!-- ELGA_HistoryOfProcedures -->
   <include href="include/1.2.40.0.34.6.0.11.3.48-2023-02-03T102536.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.48-2023-02-03T102536-closed.sch"/>
   <!-- atcdabbr_entry_ProblemStatusObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.49-2021-02-19T125553.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.49-2021-02-19T125553-closed.sch"/>
   <!-- atcdabbr_entry_MedicationStatement -->
   <include href="include/1.2.40.0.34.6.0.11.3.50-2021-02-19T125214.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.50-2021-02-19T125214-closed.sch"/>
   <!-- atcdabbr_entry_Procedure -->
   <include href="include/1.2.40.0.34.6.0.11.3.51-2023-02-03T103752.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.51-2023-02-03T103752-closed.sch"/>
   <!-- atcdabbr_entry_Logo -->
   <include href="include/1.2.40.0.34.6.0.11.3.53-2021-06-28T110849.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.53-2021-06-28T110849-closed.sch"/>
   <!-- atcdabbr_entry_Problem -->
   <include href="include/1.2.40.0.34.6.0.11.3.6-2023-02-02T155045.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.6-2023-02-02T155045-closed.sch"/>
   <!-- atcdabbr_entry_ProblemConcern -->
   <include href="include/1.2.40.0.34.6.0.11.3.7-2021-02-19T125533.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.7-2021-02-19T125533-closed.sch"/>
   <!-- atcdabbr_entry_MedikationsEinnahmeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.72-2025-03-20T094206.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.72-2025-03-20T094206-closed.sch"/>
   <!-- atcdabbr_other_PerformerBody -->
   <include href="include/1.2.40.0.34.6.0.11.9.17-2021-02-19T133615.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.9.17-2021-02-19T133615-closed.sch"/>

</schema>
