<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.9.46
Name: Participant Body - Authorized Editor
Description: 
                 Dokumentation der eindeutigen Kennung des GDA (OID aus dem GDA-Index), der einen Eintrag (Entry) bearbeiten darf ("Berechtigter bearbeitender GDA"). Wird durch die zentrale Anwendung automatisch befüllt. 
                 Dient der GDA-Software diejenigen Einträge zu erkennen, die durch den GDA bearbeitet werden dürfen. 
                 Hintergrund: Das Berechtigungssystem erlaubt die Korrektur eines Eintrags nur dem GDA, der den Eintrag ursprünglich erstellt hat (document.author des zugrundeliegenden "Update Immunisierungsstatus"), oder GDA mit der Rolle "Korrekturberechtigte Person". Wurde ein Eintrag durch einen GDA mit der Rolle "Korrekturberechtigte Person" korrigiert, ist fortan die Änderung dieses
                    Eintrags nur mehr GDA mit der Rolle "Korrekturberechtigte Person" möglich. 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910">
   <title>Participant Body - Authorized Editor</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.46
Context: *[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]
Item: (Participant Body - Authorized Editor)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]"
         id="d44e104305-false-d6077244e0">
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']) &gt;= 1">(Participant Body - Authorized Editor): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']) &lt;= 1">(Participant Body - Authorized Editor): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="count(hl7:participantRole[not(@nullFlavor)]) &gt;= 1">(Participant Body - Authorized Editor): Element hl7:participantRole[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="count(hl7:participantRole[not(@nullFlavor)]) &lt;= 1">(Participant Body - Authorized Editor): Element hl7:participantRole[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.46
Context: *[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']
Item: (Participant Body - Authorized Editor)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']"
         id="d44e104339-false-d6077269e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Participant Body - Authorized Editor): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.9.46')">(Participant Body - Authorized Editor): Der Wert von root MUSS '1.2.40.0.34.6.0.11.9.46' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.46
Context: *[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]/hl7:participantRole[not(@nullFlavor)]
Item: (Participant Body - Authorized Editor)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]/hl7:participantRole[not(@nullFlavor)]"
         id="d44e104347-false-d6077283e0">
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(Participant Body - Authorized Editor): Der Wert von classCode MUSS 'ROL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="count(hl7:id[not(@nullFlavor)][not(@nullFlavor)]) &gt;= 1">(Participant Body - Authorized Editor): Element hl7:id[not(@nullFlavor)][not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="count(hl7:id[not(@nullFlavor)][not(@nullFlavor)]) &lt;= 1">(Participant Body - Authorized Editor): Element hl7:id[not(@nullFlavor)][not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.46
Context: *[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]/hl7:participantRole[not(@nullFlavor)]/hl7:id[not(@nullFlavor)][not(@nullFlavor)]
Item: (Participant Body - Authorized Editor)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.2.40.0.34.6.0.11.9.46']]/hl7:participantRole[not(@nullFlavor)]/hl7:id[not(@nullFlavor)][not(@nullFlavor)]"
         id="d44e104351-false-d6077299e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Participant Body - Authorized Editor): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="not(@root) or (string-length(@root) &gt; 0 and not(matches(@root,'\s')))">(Participant Body - Authorized Editor): Attribute @root MUSS vom Datentyp 'cs' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elgaambbef-html-20250908T130124/tmp-1.2.40.0.34.6.0.11.9.46-2023-04-04T103910.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Participant Body - Authorized Editor): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>
</pattern>
