<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.20.6.2.9
Name: Purpose of Reference Observation
Description: A Purpose of Reference Observation describes the purpose of the DICOM composite object reference. Appropriate codes, such as externally defined DICOM codes, may be used to specify the semantics of the purpose of reference. When this observation is absent, it implies that the reason for the reference is unknown.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000">
   <title>Purpose of Reference Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.9
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]
Item: (Purpose of Reference Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.9
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]
Item: (Purpose of Reference Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]"
         id="d45e19288-false-d183042e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="string(@classCode) = ('OBS')">CONF:81-9264: Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="string(@moodCode) = ('EVN')">CONF:81-9265: Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']) &gt;= 1">(Purpose of Reference Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']) &lt;= 1">(Purpose of Reference Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="count(cda:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &gt;= 1">(Purpose of Reference Observation): Element cda:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="count(cda:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]) &lt;= 1">(Purpose of Reference Observation): Element cda:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="count(cda:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.11.20.9.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Purpose of Reference Observation): Element cda:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.11.20.9.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.9
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']
Item: (Purpose of Reference Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']"
         id="d45e19306-false-d183086e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Purpose of Reference Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.6.2.9')">CONF:81-10531: Der Wert von root MUSS '2.16.840.1.113883.10.20.6.2.9' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.9
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]/cda:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]
Item: (Purpose of Reference Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]/cda:code[(@code = 'ASSERTION' and @codeSystem = '2.16.840.1.113883.5.4')]"
         id="d45e19322-false-d183101e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Purpose of Reference Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="@nullFlavor or (@code='ASSERTION' and @codeSystem='2.16.840.1.113883.5.4')">(Purpose of Reference Observation): Der Elementinhalt MUSS einer von 'code 'ASSERTION' codeSystem '2.16.840.1.113883.5.4'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.9
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]/cda:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.11.20.9.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Purpose of Reference Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]/cda:value[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.11.20.9.28-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d45e19332-false-d183120e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Purpose of Reference Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.9-2015-08-13T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.11.20.9.28-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Purpose of Reference Observation): Der Elementinhalt MUSS einer von '2.16.840.1.113883.11.20.9.28 DICOMPurposeOfReference (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
