<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.20.6.2.8
Name: SOP Instance Observation
Description: A SOP Instance Observation contains the DICOM Service Object Pair (SOP) Instance information for referenced DICOM composite objects. The SOP Instance act class is used to reference both image and non-image DICOM instances. The text attribute contains the DICOM WADO reference.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000">
   <title>SOP Instance Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]
Item: (SOP Instance Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']"
         id="d45e19124-false-d182797e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@classCode) = ('DGIMG')">CONF:81-9240: Der Wert von classCode MUSS 'DGIMG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@moodCode) = ('EVN')">CONF:81-9241: Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']) &gt;= 1">(SOP Instance Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']) &lt;= 1">(SOP Instance Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:id) &gt;= 1">(SOP Instance Observation): Element cda:id ist required [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:code[@codeSystem = '1.2.840.10008.2.6.1']) &gt;= 1">(SOP Instance Observation): Element cda:code[@codeSystem = '1.2.840.10008.2.6.1'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:code[@codeSystem = '1.2.840.10008.2.6.1']) &lt;= 1">(SOP Instance Observation): Element cda:code[@codeSystem = '1.2.840.10008.2.6.1'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:text[cda:reference]) &lt;= 1">(SOP Instance Observation): Element cda:text[cda:reference] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:effectiveTime) &lt;= 1">(SOP Instance Observation): Element cda:effectiveTime kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']"
         id="d45e19142-false-d182870e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(SOP Instance Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.6.2.8')">(SOP Instance Observation): Der Wert von root MUSS '2.16.840.1.113883.10.20.6.2.8' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:id
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:id"
         id="d45e19150-false-d182884e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(SOP Instance Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:code[@codeSystem = '1.2.840.10008.2.6.1']
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:code[@codeSystem = '1.2.840.10008.2.6.1']"
         id="d45e19160-false-d182895e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="@nullFlavor or (@codeSystem='1.2.840.10008.2.6.1')">(SOP Instance Observation): Der Elementinhalt MUSS einer von 'codeSystem '1.2.840.10008.2.6.1'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:text[cda:reference]
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:text[cda:reference]"
         id="d45e19177-false-d182908e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@mediaType) = ('application/dicom')">CONF:81-9247: Der Wert von mediaType MUSS 'application/dicom' sein. Gefunden: "<value-of select="@mediaType"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:reference) &gt;= 1">(SOP Instance Observation): Element cda:reference ist required [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:reference) &lt;= 1">(SOP Instance Observation): Element cda:reference kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:text[cda:reference]/cda:reference
Item: (SOP Instance Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:effectiveTime
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:effectiveTime"
         id="d45e19204-false-d182936e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="@value">CONF:81-9251: Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:low) = 0">(SOP Instance Observation): Element cda:low DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="count(cda:high) = 0">(SOP Instance Observation): Element cda:high DARF NICHT vorkommen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:effectiveTime/cda:low
Item: (SOP Instance Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:effectiveTime/cda:high
Item: (SOP Instance Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:entryRelationship[@typeCode = 'SUBJ']
Item: (SOP Instance Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:entryRelationship[@typeCode = 'SUBJ']"
         id="d45e19236-false-d182975e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@typeCode) = ('SUBJ')">CONF:81-9255: Der Wert von typeCode MUSS 'SUBJ' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]
Item: (SOP Instance Observation)
-->
   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.9']]]">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@typeCode) = ('RSON')">CONF:81-9258: Der Wert von typeCode MUSS 'RSON' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.8
Context: *[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]
Item: (SOP Instance Observation)
-->
   <rule fpi="RULC-1"
         context="*[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']]/cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1']/cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.8-2015-08-13T000000.html"
              test="string(@typeCode) = ('COMP')">CONF:81-9261: Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
