<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.20.6.2.6
Name: Study Act
Description: A Study Act contains the DICOM study information that defines the characteristics of a referenced medical study performed on a patient. A study is a collection of one or more series of medical images, presentation states, SR documents, overlays, and/or curves that are logically related for the purpose of diagnosing a patient. Each study is associated with exactly
                one patient. A study may include composite instances that are created by a single modality, multiple modalities, or by multiple devices of the same modality. The study information is modality-independent. Study Act clinical statements are only instantiated in the DICOM Object Catalog section; in other sections, the SOP Instance Observation is included directly.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000">
   <title>Study Act</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]
Item: (Study Act)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]
Item: (Study Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]"
         id="d45e18997-false-d182613e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="string(@classCode) = ('ACT')">CONF:81-9207: Der Wert von classCode MUSS 'ACT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="string(@moodCode) = ('EVN')">CONF:81-9208: Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']) &gt;= 1">(Study Act): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']) &lt;= 1">(Study Act): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:id[not(@extension)]) &gt;= 1">(Study Act): Element cda:id[not(@extension)] ist required [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:code[(@code = '113014' and @codeSystem = '1.2.840.10008.2.16.4')]) &gt;= 1">(Study Act): Element cda:code[(@code = '113014' and @codeSystem = '1.2.840.10008.2.16.4')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:code[(@code = '113014' and @codeSystem = '1.2.840.10008.2.16.4')]) &lt;= 1">(Study Act): Element cda:code[(@code = '113014' and @codeSystem = '1.2.840.10008.2.16.4')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:text) &lt;= 1">(Study Act): Element cda:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:effectiveTime) &lt;= 1">(Study Act): Element cda:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:entryRelationship[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]) &gt;= 1">(Study Act): Element cda:entryRelationship[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]] ist mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']
Item: (Study Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']"
         id="d45e19015-false-d182680e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Study Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.6.2.6')">CONF:81-10533: Der Wert von root MUSS '2.16.840.1.113883.10.20.6.2.6' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:id[not(@extension)]
Item: (Study Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:id[not(@extension)]"
         id="d45e19031-false-d182694e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Study Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="@root">CONF:81-9213: Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="not(@extension)">(Study Act): Attribut @extension DARF NICHT vorkommen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:code[(@code = '113014' and @codeSystem = '1.2.840.10008.2.16.4')]
Item: (Study Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:code[(@code = '113014' and @codeSystem = '1.2.840.10008.2.16.4')]"
         id="d45e19053-false-d182712e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Study Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="@nullFlavor or (@code='113014' and @codeSystem='1.2.840.10008.2.16.4')">(Study Act): Der Elementinhalt MUSS einer von 'code '113014' codeSystem '1.2.840.10008.2.16.4'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:text
Item: (Study Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:text"
         id="d45e19064-false-d182728e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="count(cda:reference) &lt;= 1">(Study Act): Element cda:reference kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:text/cda:reference
Item: (Study Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:text/cda:reference"
         id="d45e19073-false-d182742e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="not(@value) or starts-with(@value, '#')">(Study Act): This reference/@value SHALL begin with a '#' and SHALL point to its corresponding narrative (using the approach defined in CDA Release 2, section 4.3.5.1)</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:effectiveTime
Item: (Study Act)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.6
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:entryRelationship[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]
Item: (Study Act)
-->
   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.6']]/cda:entryRelationship[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.6-2015-08-13T000000.html"
              test="string(@typeCode) = ('COMP')">CONF:81-9220: Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
