<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.20.6.2.11
Name: Boundary Observation
Description: A Boundary Observation contains a list of integer values for the referenced frames of a DICOM multiframe image SOP instance. It identifies the frame numbers within the referenced SOP instance to which the reference applies. The CDA Boundary Observation numbers frames using the same convention as DICOM, with the first frame in the referenced object being Frame 1.
                A Boundary Observation must be used if a referenced DICOM SOP instance is a multiframe image and the reference does not apply to all frames.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000">
   <title>Boundary Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.11
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]
Item: (Boundary Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.11
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]
Item: (Boundary Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]"
         id="d45e18944-false-d182481e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="string(@classCode) = ('OBS')">CONF:81-9282: Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="string(@moodCode) = ('EVN')">CONF:81-9283: Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']) &gt;= 1">(Boundary Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']) &lt;= 1">(Boundary Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="count(cda:code[(@code = '113036' and @codeSystem = '1.2.840.10008.2.16.4')]) &gt;= 1">(Boundary Observation): Element cda:code[(@code = '113036' and @codeSystem = '1.2.840.10008.2.16.4')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="count(cda:code[(@code = '113036' and @codeSystem = '1.2.840.10008.2.16.4')]) &lt;= 1">(Boundary Observation): Element cda:code[(@code = '113036' and @codeSystem = '1.2.840.10008.2.16.4')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="count(cda:value) &gt;= 1">(Boundary Observation): Element cda:value ist required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.11
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']
Item: (Boundary Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']"
         id="d45e18962-false-d182522e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Boundary Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.6.2.11')">(Boundary Observation): Der Wert von root MUSS '2.16.840.1.113883.10.20.6.2.11' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.11
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]/cda:code[(@code = '113036' and @codeSystem = '1.2.840.10008.2.16.4')]
Item: (Boundary Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]/cda:code[(@code = '113036' and @codeSystem = '1.2.840.10008.2.16.4')]"
         id="d45e18970-false-d182537e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Boundary Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="@nullFlavor or (@code='113036' and @codeSystem='1.2.840.10008.2.16.4')">(Boundary Observation): Der Elementinhalt MUSS einer von 'code '113036' codeSystem '1.2.840.10008.2.16.4'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.11
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]/cda:value
Item: (Boundary Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]/cda:value"
         id="d45e18980-false-d182553e0">
      <extends rule="INT"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(Boundary Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.11-2015-08-13T000000.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(Boundary Observation): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>
</pattern>
