<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.20.6.2.10
Name: Referenced Frames Observation
Description: A Referenced Frames Observation is used if the referenced DICOM SOP instance is a multiframe image and the reference does not apply to all frames. The list of integer values for the referenced frames of a DICOM multiframe image SOP instance is contained in a Boundary Observation nested inside this class.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000">
   <title>Referenced Frames Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.10
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]
Item: (Referenced Frames Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.10
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]
Item: (Referenced Frames Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]"
         id="d45e18888-false-d182369e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="string(@classCode) = ('ROIBND')">CONF:81-9276: Der Wert von classCode MUSS 'ROIBND' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="string(@moodCode) = ('EVN')">CONF:81-9277: Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']) &gt;= 1">(Referenced Frames Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']) &lt;= 1">(Referenced Frames Observation): Element cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="count(cda:code[(@code = '121190' and @codeSystem = '1.2.840.10008.2.16.4')]) &gt;= 1">(Referenced Frames Observation): Element cda:code[(@code = '121190' and @codeSystem = '1.2.840.10008.2.16.4')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="count(cda:code[(@code = '121190' and @codeSystem = '1.2.840.10008.2.16.4')]) &lt;= 1">(Referenced Frames Observation): Element cda:code[(@code = '121190' and @codeSystem = '1.2.840.10008.2.16.4')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="count(cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]) &gt;= 1">(Referenced Frames Observation): Element cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="count(cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]) &lt;= 1">(Referenced Frames Observation): Element cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.10
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']
Item: (Referenced Frames Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]/cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']"
         id="d45e18906-false-d182414e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Referenced Frames Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.6.2.10')">(Referenced Frames Observation): Der Wert von root MUSS '2.16.840.1.113883.10.20.6.2.10' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.10
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]/cda:code[(@code = '121190' and @codeSystem = '1.2.840.10008.2.16.4')]
Item: (Referenced Frames Observation)
-->

   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]/cda:code[(@code = '121190' and @codeSystem = '1.2.840.10008.2.16.4')]"
         id="d45e18914-false-d182429e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Referenced Frames Observation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="@nullFlavor or (@code='121190' and @codeSystem='1.2.840.10008.2.16.4')">(Referenced Frames Observation): Der Elementinhalt MUSS einer von 'code '121190' codeSystem '1.2.840.10008.2.16.4'' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.6.2.10
Context: *[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]/cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]
Item: (Referenced Frames Observation)
-->
   <rule fpi="RULC-1"
         context="*[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]]/cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.10']]/cda:entryRelationship[cda:observation[cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.11']]]">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.6.2.10-2015-08-13T000000.html"
              test="string(@typeCode) = ('COMP')">CONF:81-9280: Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
