<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.10.20.22.4.63
Name: Series Act
Description: A Series Act contains the DICOM series information for referenced DICOM composite objects. The series information defines the attributes that are used to group composite instances into distinct logical sets. Each series is associated with exactly one study. Series Act clinical statements are only instantiated in the DICOM Object Catalog section inside a Study
                Act, and thus do not require a separate templateId; in other sections, the SOP Instance Observation is included directly.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000">
   <title>Series Act</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]
Item: (Series Act)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]
Item: (Series Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]"
         id="d45e18696-false-d181997e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="string(@classCode) = ('ACT')">CONF:81-9222: Der Wert von classCode MUSS 'ACT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="string(@moodCode) = ('EVN')">CONF:81-9223: Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']) &gt;= 1">(Series Act): Element cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']) &lt;= 1">(Series Act): Element cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:id[not(@extension)]) &gt;= 1">(Series Act): Element cda:id[not(@extension)] ist required [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]) &gt;= 1">(Series Act): Element cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]) &lt;= 1">(Series Act): Element cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:text) &lt;= 1">(Series Act): Element cda:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:effectiveTime) &lt;= 1">(Series Act): Element cda:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:entryRelationship[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1'][cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']]]) &gt;= 1">(Series Act): Element cda:entryRelationship[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1'][cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']]] ist mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']
Item: (Series Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']"
         id="d45e18714-false-d182064e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Series Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.22.4.63')">CONF:81-10919: Der Wert von root MUSS '2.16.840.1.113883.10.20.22.4.63' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:id[not(@extension)]
Item: (Series Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:id[not(@extension)]"
         id="d45e18730-false-d182078e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Series Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="@root">CONF:81-9225: Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="not(@extension)">(Series Act): Attribut @extension DARF NICHT vorkommen.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]
Item: (Series Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]"
         id="d45e18752-false-d182096e0">
      <extends rule="CD"/>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Series Act): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="@nullFlavor or (@code='113015' and @codeSystem='1.2.840.10008.2.16.4')">(Series Act): Der Elementinhalt MUSS einer von 'code '113015' codeSystem '1.2.840.10008.2.16.4'' sein.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]) &gt;= 1">(Series Act): Element cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]) &lt;= 1">(Series Act): Element cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]/cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]
Item: (Series Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]/cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]"
         id="d45e18761-false-d182122e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]) &gt;= 1">(Series Act): Element cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]) &lt;= 1">(Series Act): Element cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:value) &gt;= 1">(Series Act): Element cda:value ist required [min 1x].</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="count(cda:value) &lt;= 1">(Series Act): Element cda:value kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]/cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]/cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]
Item: (Series Act)
-->

   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]/cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]/cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]"
         id="d45e18768-false-d182148e0">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="@nullFlavor or (@code='121139' and @codeSystem='1.2.840.10008.2.16.4')">(Series Act): Der Elementinhalt MUSS einer von 'code '121139' codeSystem '1.2.840.10008.2.16.4'' sein.</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="string(@code) = ('121139')">CONF:81-26464: Der Wert von code MUSS '121139' sein. Gefunden: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="string(@codeSystem) = ('1.2.840.10008.2.16.4')">CONF:81-26465: Der Wert von codeSystem MUSS '1.2.840.10008.2.16.4' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:code[(@code = '113015' and @codeSystem = '1.2.840.10008.2.16.4')]/cda:qualifier[cda:name[(@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4') or (@code = '121139' and @codeSystem = '1.2.840.10008.2.16.4')]]/cda:value
Item: (Series Act)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:text
Item: (Series Act)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:effectiveTime
Item: (Series Act)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.10.20.22.4.63
Context: *[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:entryRelationship[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1'][cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']]]
Item: (Series Act)
-->
   <rule fpi="RULC-1"
         context="*[cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]]/cda:act[cda:templateId[@root = '2.16.840.1.113883.10.20.22.4.63']]/cda:entryRelationship[cda:observation[cda:code/@codeSystem='1.2.840.10008.2.6.1'][cda:templateId[@root = '2.16.840.1.113883.10.20.6.2.8']]]">
      <assert role="error"
              see="http://elga.art-decor.org/elga-html-20251024T110105/tmp-2.16.840.1.113883.10.20.22.4.63-2015-08-13T000000.html"
              test="string(@typeCode) = ('COMP')">CONF:81-9238: Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
