<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.1.29
Name: Participant Betreuungsorganisation
Description: 
                 Als  betreuende Organisation  ist jene Organisation anzusehen, welche den Patienten nach Entlassung betreut (Trägerorganisationen, Vereine). 
                 Beispiele: Mobile Hauskrankenpflege, Wohn- und Pflegeheime, Behinderteneinrichtungen, sozial betreutes Wohnen, … 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540">
   <title>Participant Betreuungsorganisation</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.29
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]
Item: (Participant Betreuungsorganisation)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.29
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]
Item: (Participant Betreuungsorganisation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]"
         id="d45e3174-false-d1519230e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="string(@typeCode) = ('IND')">(Participant Betreuungsorganisation): Der Wert von typeCode MUSS 'IND' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Participant Betreuungsorganisation): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.1.29']) &gt;= 1">(Participant Betreuungsorganisation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.1.29'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.1.29']) &lt;= 1">(Participant Betreuungsorganisation): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.1.29'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]) &gt;= 1">(Participant Betreuungsorganisation): Element hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]) &lt;= 1">(Participant Betreuungsorganisation): Element hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.29
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.1.29']
Item: (Participant Betreuungsorganisation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.1.29']"
         id="d45e3179-false-d1519277e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Participant Betreuungsorganisation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.1.29')">(Participant Betreuungsorganisation): Der Wert von root MUSS '1.2.40.0.34.6.0.11.1.29' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.29
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]
Item: (Participant Betreuungsorganisation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]"
         id="d45e3184-false-d1519304e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="string(@classCode) = ('CAREGIVER')">(Participant Betreuungsorganisation): Der Wert von classCode MUSS 'CAREGIVER' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:scopingOrganization[not(@nullFlavor)]) &gt;= 1">(Participant Betreuungsorganisation): Element hl7:scopingOrganization[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:scopingOrganization[not(@nullFlavor)]) &lt;= 1">(Participant Betreuungsorganisation): Element hl7:scopingOrganization[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.29
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]
Item: (Participant Betreuungsorganisation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]"
         id="d45e3192-false-d1519350e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(Participant Betreuungsorganisation): Der Wert von classCode MUSS 'ORG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Participant Betreuungsorganisation): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Participant Betreuungsorganisation): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Participant Betreuungsorganisation): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(Participant Betreuungsorganisation): Element hl7:addr[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.9
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (Organization Compilation with name)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d1519361e71-false-d1519384e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Organization Compilation with name): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.9
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Organization Compilation with name)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d1519361e77-false-d1519394e0">
      <extends rule="ON"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(Organization Compilation with name): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ON" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.9
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:telecom[not(@nullFlavor)]
Item: (Organization Compilation with name)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:telecom[not(@nullFlavor)]"
         id="d1519361e85-false-d1519402e0">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Organization Compilation with name): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="@value">(Organization Compilation with name): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="not(@value) or string-length(@value)&gt;0">(Organization Compilation with name): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="not(@use) or string-length(@use) &gt; 0">(Organization Compilation with name): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.9
Context: *[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (Organization Compilation with name)
-->

   <rule fpi="RULC-1"
         context="*[hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]]/hl7:participant[hl7:templateId[@root='1.2.40.0.34.6.0.11.1.29']]/hl7:associatedEntity[not(@nullFlavor)][@classCode = 'CAREGIVER'][hl7:scopingOrganization]/hl7:scopingOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]"
         id="d1519361e126-false-d1519419e0">
      <extends rule="AD"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.9.9-2021-02-19T133125.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(Organization Compilation with name): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:AD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
