<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction Pflegesituationsbericht v3 (1.2.40.0.34.777.19.4.2 2025-06-26T00:00:00)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <ns uri="urn:hl7-at:v3" prefix="hl7at"/>
   <ns uri="urn:ihe:pharm" prefix="pharm"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <ns uri="urn:hl7-org:ips" prefix="ips"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'Pflegesituationsbericht'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario Pflegesituationsbericht -->

   <!-- atpflege_document_Pflegesituationsbericht -->
   <pattern>
      <title>atpflege_document_Pflegesituationsbericht</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.30.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.25']]"
                 see="https://elga.art-decor.org/at-pflege-html-20260206T095644/tmp-1.2.40.0.34.6.0.11.0.25-2025-06-25T134944.html">(Pflegesituationsbericht): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.30.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.25']]</assert>
      </rule>
   </pattern>
   <include href="include/1.2.40.0.34.6.0.11.0.25-2025-06-25T134944.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.0.25-2025-06-25T134944-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-1.2.40.0.34.6.0.11.0.25-2025-06-25T134944"/>
      <active pattern="template-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.141-2025-07-09T164909"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.142-2025-07-09T172434"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.143-2025-07-09T172829"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.144-2025-07-09T173100"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.145-2025-07-09T173603"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.146-2025-07-09T173822"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.147-2025-07-09T173927"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.148-2025-07-09T174012"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.149-2025-07-09T174122"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.150-2025-09-02T123255"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.151-2025-07-09T174434"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.152-2025-07-09T174540"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.153-2025-07-09T174656"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.154-2025-07-09T175031"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.155-2025-07-09T175125"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.157-2025-07-09T211136"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.158-2025-07-09T211136"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.159-2025-07-09T211136"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.161-2025-07-16T083132"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.162-2025-07-20T105026"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.163-2025-07-20T105026"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.46-2021-02-19T120303"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.61-2025-07-16T073256"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.62-2021-02-19T115806"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.68-2025-07-16T132358"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.69-2021-06-28T111935"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.70-2021-06-28T112503"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.71-2026-01-13T083631"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.75-2021-02-19T114034"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.76-2021-02-19T115759"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.77-2021-02-19T114625"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.8-2023-04-13T110152"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.9-2026-01-14T131341"/>
      <active pattern="template-1.2.40.0.34.6.0.11.2.95-2026-01-14T085807"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.100-2021-01-28T145003"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.101-2021-01-21T081221"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.102-2021-02-19T125910"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.103-2021-01-28T145841"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.104-2021-02-19T125919"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.11-2021-02-19T124256"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.14-2023-04-13T110204"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.189-2025-07-16T125932"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.19-2023-05-09T164236"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.192-2026-01-07T110723"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.23-2021-02-19T130106"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.24-2025-02-13T113313"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.35-2021-06-28T134402"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.36-2021-02-19T124249"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.38-2021-02-19T130038"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.49-2021-02-19T125553"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.53-2021-06-28T110849"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.70-2021-02-18T133433"/>
      <active pattern="template-1.2.40.0.34.6.0.11.3.71-2021-02-18T133403"/>
      <active pattern="template-1.2.40.0.34.6.0.11.9.17-2021-02-19T133615"/>
   </phase>
   <phase id="atpflege_document_Pflegesituationsbericht">
      <active pattern="template-1.2.40.0.34.6.0.11.0.25-2025-06-25T134944"/>
   </phase>
   <phase id="atpflege_document_Pflegesituationsbericht-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.0.25-2025-06-25T134944-closed"/>
   </phase>
   <phase id="atcdabbr_header_ParticipantBetreuungsorganisation">
      <active pattern="template-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540"/>
   </phase>
   <phase id="atcdabbr_header_ParticipantBetreuungsorganisation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.1.29-2025-12-09T125540-closed"/>
   </phase>
   <phase id="atcdabbr_section_Mobilitaet">
      <active pattern="template-1.2.40.0.34.6.0.11.2.141-2025-07-09T164909"/>
   </phase>
   <phase id="atcdabbr_section_Mobilitaet-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.141-2025-07-09T164909-closed"/>
   </phase>
   <phase id="atcdabbr_section_KoerperpflegeKleiden">
      <active pattern="template-1.2.40.0.34.6.0.11.2.142-2025-07-09T172434"/>
   </phase>
   <phase id="atcdabbr_section_KoerperpflegeKleiden-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.142-2025-07-09T172434-closed"/>
   </phase>
   <phase id="atcdabbr_section_Ernaehrung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.143-2025-07-09T172829"/>
   </phase>
   <phase id="atcdabbr_section_Ernaehrung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.143-2025-07-09T172829-closed"/>
   </phase>
   <phase id="atcdabbr_section_Ausscheidung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.144-2025-07-09T173100"/>
   </phase>
   <phase id="atcdabbr_section_Ausscheidung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.144-2025-07-09T173100-closed"/>
   </phase>
   <phase id="atcdabbr_section_Hautzustand">
      <active pattern="template-1.2.40.0.34.6.0.11.2.145-2025-07-09T173603"/>
   </phase>
   <phase id="atcdabbr_section_Hautzustand-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.145-2025-07-09T173603-closed"/>
   </phase>
   <phase id="atcdabbr_section_Atmung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.146-2025-07-09T173822"/>
   </phase>
   <phase id="atcdabbr_section_Atmung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.146-2025-07-09T173822-closed"/>
   </phase>
   <phase id="atcdabbr_section_SchlafUndRuhe">
      <active pattern="template-1.2.40.0.34.6.0.11.2.147-2025-07-09T173927"/>
   </phase>
   <phase id="atcdabbr_section_SchlafUndRuhe-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.147-2025-07-09T173927-closed"/>
   </phase>
   <phase id="atcdabbr_section_Schmerz">
      <active pattern="template-1.2.40.0.34.6.0.11.2.148-2025-07-09T174012"/>
   </phase>
   <phase id="atcdabbr_section_Schmerz-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.148-2025-07-09T174012-closed"/>
   </phase>
   <phase id="atcdabbr_section_OrientierungBewusstseinslage">
      <active pattern="template-1.2.40.0.34.6.0.11.2.149-2025-07-09T174122"/>
   </phase>
   <phase id="atcdabbr_section_OrientierungBewusstseinslage-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.149-2025-07-09T174122-closed"/>
   </phase>
   <phase id="atcdabbr_section_SozialesUmfeldUndVerhalten">
      <active pattern="template-1.2.40.0.34.6.0.11.2.150-2025-09-02T123255"/>
   </phase>
   <phase id="atcdabbr_section_SozialesUmfeldUndVerhalten-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.150-2025-09-02T123255-closed"/>
   </phase>
   <phase id="atcdabbr_section_KommunikationUndInteraktion">
      <active pattern="template-1.2.40.0.34.6.0.11.2.151-2025-07-09T174434"/>
   </phase>
   <phase id="atcdabbr_section_KommunikationUndInteraktion-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.151-2025-07-09T174434-closed"/>
   </phase>
   <phase id="atcdabbr_section_RollenwahrnehmungSinnfindung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.152-2025-07-09T174540"/>
   </phase>
   <phase id="atcdabbr_section_RollenwahrnehmungSinnfindung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.152-2025-07-09T174540-closed"/>
   </phase>
   <phase id="atcdabrr_section_PflegerelevanteInformationenZurMedizinischenBehandlung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.153-2025-07-09T174656"/>
   </phase>
   <phase id="atcdabrr_section_PflegerelevanteInformationenZurMedizinischenBehandlung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.153-2025-07-09T174656-closed"/>
   </phase>
   <phase id="atcdabbr_section_Medikamentenverabreichung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.154-2025-07-09T175031"/>
   </phase>
   <phase id="atcdabbr_section_Medikamentenverabreichung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.154-2025-07-09T175031-closed"/>
   </phase>
   <phase id="atcdabbr_section_Entlassmanag_Pflegebetreuumfang">
      <active pattern="template-1.2.40.0.34.6.0.11.2.155-2025-07-09T175125"/>
   </phase>
   <phase id="atcdabbr_section_Entlassmanag_Pflegebetreuumfang-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.155-2025-07-09T175125-closed"/>
   </phase>
   <phase id="atcdabbr_section_Assessments">
      <active pattern="template-1.2.40.0.34.6.0.11.2.157-2025-07-09T211136"/>
   </phase>
   <phase id="atcdabbr_section_Assessments-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.157-2025-07-09T211136-closed"/>
   </phase>
   <phase id="atcdabbr_section_Pflegeintervention">
      <active pattern="template-1.2.40.0.34.6.0.11.2.158-2025-07-09T211136"/>
   </phase>
   <phase id="atcdabbr_section_Pflegeintervention-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.158-2025-07-09T211136-closed"/>
   </phase>
   <phase id="atcdabbr_section_Pflegeziel">
      <active pattern="template-1.2.40.0.34.6.0.11.2.159-2025-07-09T211136"/>
   </phase>
   <phase id="atcdabbr_section_Pflegeziel-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.159-2025-07-09T211136-closed"/>
   </phase>
   <phase id="atcdabbr_section_VitalparameterUndMessergebnisseKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.161-2025-07-16T083132"/>
   </phase>
   <phase id="atcdabbr_section_VitalparameterUndMessergebnisseKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.161-2025-07-16T083132-closed"/>
   </phase>
   <phase id="atcdabrr_section_PflegediagnosenKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.162-2025-07-20T105026"/>
   </phase>
   <phase id="atcdabrr_section_PflegediagnosenKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.162-2025-07-20T105026-closed"/>
   </phase>
   <phase id="atcdabrr_section_PflegediagnosenUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.163-2025-07-20T105026"/>
   </phase>
   <phase id="atcdabrr_section_PflegediagnosenUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.163-2025-07-20T105026-closed"/>
   </phase>
   <phase id="atcdabrr_section_VitalparameterKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.46-2021-02-19T120303"/>
   </phase>
   <phase id="atcdabrr_section_VitalparameterKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.46-2021-02-19T120303-closed"/>
   </phase>
   <phase id="atcdabrr_section_WillenserklaerungenUndAndereJuridischeDokumente">
      <active pattern="template-1.2.40.0.34.6.0.11.2.61-2025-07-16T073256"/>
   </phase>
   <phase id="atcdabrr_section_WillenserklaerungenUndAndereJuridischeDokumente-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.61-2025-07-16T073256-closed"/>
   </phase>
   <phase id="atcdabrr_section_SUBWillenserklaerungenUndAndereJuridischeDokumente">
      <active pattern="template-1.2.40.0.34.6.0.11.2.62-2021-02-19T115806"/>
   </phase>
   <phase id="atcdabrr_section_SUBWillenserklaerungenUndAndereJuridischeDokumente-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.62-2021-02-19T115806-closed"/>
   </phase>
   <phase id="atcdabbr_section_VitalparameterUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.68-2025-07-16T132358"/>
   </phase>
   <phase id="atcdabbr_section_VitalparameterUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.68-2025-07-16T132358-closed"/>
   </phase>
   <phase id="atcdabbr_section_Brieftext">
      <active pattern="template-1.2.40.0.34.6.0.11.2.69-2021-06-28T111935"/>
   </phase>
   <phase id="atcdabbr_section_Brieftext-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.69-2021-06-28T111935-closed"/>
   </phase>
   <phase id="atcdabbr_section_AbschliessendeBemerkung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.70-2021-06-28T112503"/>
   </phase>
   <phase id="atcdabbr_section_AbschliessendeBemerkung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.70-2021-06-28T112503-closed"/>
   </phase>
   <phase id="atcdabbr_section_Beilagen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.71-2026-01-13T083631"/>
   </phase>
   <phase id="atcdabbr_section_Beilagen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.71-2026-01-13T083631-closed"/>
   </phase>
   <phase id="atcdabrr_section_Anmerkungen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.75-2021-02-19T114034"/>
   </phase>
   <phase id="atcdabrr_section_Anmerkungen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.75-2021-02-19T114034-closed"/>
   </phase>
   <phase id="atcdabrr_section_Risiken">
      <active pattern="template-1.2.40.0.34.6.0.11.2.76-2021-02-19T115759"/>
   </phase>
   <phase id="atcdabrr_section_Risiken-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.76-2021-02-19T115759-closed"/>
   </phase>
   <phase id="atcdabrr_section_HilfsmittelRessourcen">
      <active pattern="template-1.2.40.0.34.6.0.11.2.77-2021-02-19T114625"/>
   </phase>
   <phase id="atcdabrr_section_HilfsmittelRessourcen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.77-2021-02-19T114625-closed"/>
   </phase>
   <phase id="atcdabbr_section_Uebersetzung">
      <active pattern="template-1.2.40.0.34.6.0.11.2.8-2023-04-13T110152"/>
   </phase>
   <phase id="atcdabbr_section_Uebersetzung-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.8-2023-04-13T110152-closed"/>
   </phase>
   <phase id="elgagab_section_AktuelleMedikationUnkodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.9-2026-01-14T131341"/>
   </phase>
   <phase id="elgagab_section_AktuelleMedikationUnkodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.9-2026-01-14T131341-closed"/>
   </phase>
   <phase id="atcdabbr_section_MessergebnisseKodiert">
      <active pattern="template-1.2.40.0.34.6.0.11.2.95-2026-01-14T085807"/>
   </phase>
   <phase id="atcdabbr_section_MessergebnisseKodiert-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.2.95-2026-01-14T085807-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungVitalparameterEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.100-2021-01-28T145003"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungVitalparameterEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.100-2021-01-28T145003-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.101-2021-01-21T081221"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.101-2021-01-21T081221-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungsGruppeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.102-2021-02-19T125910"/>
   </phase>
   <phase id="atcdabbr_entry_SerienmessungsGruppeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.102-2021-02-19T125910-closed"/>
   </phase>
   <phase id="SerienmessungsWerteEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.103-2021-01-28T145841"/>
   </phase>
   <phase id="SerienmessungsWerteEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.103-2021-01-28T145841-closed"/>
   </phase>
   <phase id="SerienmessungsPeriodeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.104-2021-02-19T125919"/>
   </phase>
   <phase id="SerienmessungsPeriodeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.104-2021-02-19T125919-closed"/>
   </phase>
   <phase id="atcdabrr_entry_Comment">
      <active pattern="template-1.2.40.0.34.6.0.11.3.11-2021-02-19T124256"/>
   </phase>
   <phase id="atcdabrr_entry_Comment-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.11-2021-02-19T124256-closed"/>
   </phase>
   <phase id="atcdabbr_entry_externalDocument">
      <active pattern="template-1.2.40.0.34.6.0.11.3.14-2023-04-13T110204"/>
   </phase>
   <phase id="atcdabbr_entry_externalDocument-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.14-2023-04-13T110204-closed"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemPflegediagnosen">
      <active pattern="template-1.2.40.0.34.6.0.11.3.189-2025-07-16T125932"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemPflegediagnosen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.189-2025-07-16T125932-closed"/>
   </phase>
   <phase id="atcdabbr_entry_EingebettetesObjektEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.19-2023-05-09T164236"/>
   </phase>
   <phase id="atcdabbr_entry_EingebettetesObjektEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.19-2023-05-09T164236-closed"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemConcernPflegediagnosen">
      <active pattern="template-1.2.40.0.34.6.0.11.3.192-2026-01-07T110723"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemConcernPflegediagnosen-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.192-2026-01-07T110723-closed"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterGruppeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.23-2021-02-19T130106"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterGruppeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.23-2021-02-19T130106-closed"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.24-2025-02-13T113313"/>
   </phase>
   <phase id="atcdabbr_entry_VitalparameterEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.24-2025-02-13T113313-closed"/>
   </phase>
   <phase id="atcdabbr_entry_CriticalityObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.35-2021-06-28T134402"/>
   </phase>
   <phase id="atcdabbr_entry_CriticalityObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.35-2021-06-28T134402-closed"/>
   </phase>
   <phase id="atcdabbr_entry_CertaintyObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.36-2021-02-19T124249"/>
   </phase>
   <phase id="atcdabbr_entry_CertaintyObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.36-2021-02-19T124249-closed"/>
   </phase>
   <phase id="atcdabbr_entry_SeverityObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.38-2021-02-19T130038"/>
   </phase>
   <phase id="atcdabbr_entry_SeverityObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.38-2021-02-19T130038-closed"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemStatusObservation">
      <active pattern="template-1.2.40.0.34.6.0.11.3.49-2021-02-19T125553"/>
   </phase>
   <phase id="atcdabbr_entry_ProblemStatusObservation-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.49-2021-02-19T125553-closed"/>
   </phase>
   <phase id="atcdabbr_entry_Logo">
      <active pattern="template-1.2.40.0.34.6.0.11.3.53-2021-06-28T110849"/>
   </phase>
   <phase id="atcdabbr_entry_Logo-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.53-2021-06-28T110849-closed"/>
   </phase>
   <phase id="atcdabbr_entry_MessergebnisseGruppeEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.70-2021-02-18T133433"/>
   </phase>
   <phase id="atcdabbr_entry_MessergebnisseGruppeEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.70-2021-02-18T133433-closed"/>
   </phase>
   <phase id="atcdabbr_entry_MessergebnisEntry">
      <active pattern="template-1.2.40.0.34.6.0.11.3.71-2021-02-18T133403"/>
   </phase>
   <phase id="atcdabbr_entry_MessergebnisEntry-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.3.71-2021-02-18T133403-closed"/>
   </phase>
   <phase id="atcdabbr_other_PerformerBody">
      <active pattern="template-1.2.40.0.34.6.0.11.9.17-2021-02-19T133615"/>
   </phase>
   <phase id="atcdabbr_other_PerformerBody-closed">
      <active pattern="template-1.2.40.0.34.6.0.11.9.17-2021-02-19T133615-closed"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- atcdabbr_header_ParticipantBetreuungsorganisation -->
   <include href="include/1.2.40.0.34.6.0.11.1.29-2025-12-09T125540.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.1.29-2025-12-09T125540-closed.sch"/>
   <!-- atcdabbr_section_Mobilitaet -->
   <include href="include/1.2.40.0.34.6.0.11.2.141-2025-07-09T164909.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.141-2025-07-09T164909-closed.sch"/>
   <!-- atcdabbr_section_KoerperpflegeKleiden -->
   <include href="include/1.2.40.0.34.6.0.11.2.142-2025-07-09T172434.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.142-2025-07-09T172434-closed.sch"/>
   <!-- atcdabbr_section_Ernaehrung -->
   <include href="include/1.2.40.0.34.6.0.11.2.143-2025-07-09T172829.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.143-2025-07-09T172829-closed.sch"/>
   <!-- atcdabbr_section_Ausscheidung -->
   <include href="include/1.2.40.0.34.6.0.11.2.144-2025-07-09T173100.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.144-2025-07-09T173100-closed.sch"/>
   <!-- atcdabbr_section_Hautzustand -->
   <include href="include/1.2.40.0.34.6.0.11.2.145-2025-07-09T173603.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.145-2025-07-09T173603-closed.sch"/>
   <!-- atcdabbr_section_Atmung -->
   <include href="include/1.2.40.0.34.6.0.11.2.146-2025-07-09T173822.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.146-2025-07-09T173822-closed.sch"/>
   <!-- atcdabbr_section_SchlafUndRuhe -->
   <include href="include/1.2.40.0.34.6.0.11.2.147-2025-07-09T173927.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.147-2025-07-09T173927-closed.sch"/>
   <!-- atcdabbr_section_Schmerz -->
   <include href="include/1.2.40.0.34.6.0.11.2.148-2025-07-09T174012.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.148-2025-07-09T174012-closed.sch"/>
   <!-- atcdabbr_section_OrientierungBewusstseinslage -->
   <include href="include/1.2.40.0.34.6.0.11.2.149-2025-07-09T174122.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.149-2025-07-09T174122-closed.sch"/>
   <!-- atcdabbr_section_SozialesUmfeldUndVerhalten -->
   <include href="include/1.2.40.0.34.6.0.11.2.150-2025-09-02T123255.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.150-2025-09-02T123255-closed.sch"/>
   <!-- atcdabbr_section_KommunikationUndInteraktion -->
   <include href="include/1.2.40.0.34.6.0.11.2.151-2025-07-09T174434.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.151-2025-07-09T174434-closed.sch"/>
   <!-- atcdabbr_section_RollenwahrnehmungSinnfindung -->
   <include href="include/1.2.40.0.34.6.0.11.2.152-2025-07-09T174540.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.152-2025-07-09T174540-closed.sch"/>
   <!-- atcdabrr_section_PflegerelevanteInformationenZurMedizinischenBehandlung -->
   <include href="include/1.2.40.0.34.6.0.11.2.153-2025-07-09T174656.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.153-2025-07-09T174656-closed.sch"/>
   <!-- atcdabbr_section_Medikamentenverabreichung -->
   <include href="include/1.2.40.0.34.6.0.11.2.154-2025-07-09T175031.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.154-2025-07-09T175031-closed.sch"/>
   <!-- atcdabbr_section_Entlassmanag_Pflegebetreuumfang -->
   <include href="include/1.2.40.0.34.6.0.11.2.155-2025-07-09T175125.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.155-2025-07-09T175125-closed.sch"/>
   <!-- atcdabbr_section_Assessments -->
   <include href="include/1.2.40.0.34.6.0.11.2.157-2025-07-09T211136.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.157-2025-07-09T211136-closed.sch"/>
   <!-- atcdabbr_section_Pflegeintervention -->
   <include href="include/1.2.40.0.34.6.0.11.2.158-2025-07-09T211136.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.158-2025-07-09T211136-closed.sch"/>
   <!-- atcdabbr_section_Pflegeziel -->
   <include href="include/1.2.40.0.34.6.0.11.2.159-2025-07-09T211136.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.159-2025-07-09T211136-closed.sch"/>
   <!-- atcdabbr_section_VitalparameterUndMessergebnisseKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.161-2025-07-16T083132.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.161-2025-07-16T083132-closed.sch"/>
   <!-- atcdabrr_section_PflegediagnosenKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.162-2025-07-20T105026.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.162-2025-07-20T105026-closed.sch"/>
   <!-- atcdabrr_section_PflegediagnosenUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.163-2025-07-20T105026.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.163-2025-07-20T105026-closed.sch"/>
   <!-- atcdabrr_section_VitalparameterKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.46-2021-02-19T120303.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.46-2021-02-19T120303-closed.sch"/>
   <!-- atcdabrr_section_WillenserklaerungenUndAndereJuridischeDokumente -->
   <include href="include/1.2.40.0.34.6.0.11.2.61-2025-07-16T073256.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.61-2025-07-16T073256-closed.sch"/>
   <!-- atcdabrr_section_SUBWillenserklaerungenUndAndereJuridischeDokumente -->
   <include href="include/1.2.40.0.34.6.0.11.2.62-2021-02-19T115806.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.62-2021-02-19T115806-closed.sch"/>
   <!-- atcdabbr_section_VitalparameterUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.68-2025-07-16T132358.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.68-2025-07-16T132358-closed.sch"/>
   <!-- atcdabbr_section_Brieftext -->
   <include href="include/1.2.40.0.34.6.0.11.2.69-2021-06-28T111935.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.69-2021-06-28T111935-closed.sch"/>
   <!-- atcdabbr_section_AbschliessendeBemerkung -->
   <include href="include/1.2.40.0.34.6.0.11.2.70-2021-06-28T112503.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.70-2021-06-28T112503-closed.sch"/>
   <!-- atcdabbr_section_Beilagen -->
   <include href="include/1.2.40.0.34.6.0.11.2.71-2026-01-13T083631.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.71-2026-01-13T083631-closed.sch"/>
   <!-- atcdabrr_section_Anmerkungen -->
   <include href="include/1.2.40.0.34.6.0.11.2.75-2021-02-19T114034.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.75-2021-02-19T114034-closed.sch"/>
   <!-- atcdabrr_section_Risiken -->
   <include href="include/1.2.40.0.34.6.0.11.2.76-2021-02-19T115759.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.76-2021-02-19T115759-closed.sch"/>
   <!-- atcdabrr_section_HilfsmittelRessourcen -->
   <include href="include/1.2.40.0.34.6.0.11.2.77-2021-02-19T114625.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.77-2021-02-19T114625-closed.sch"/>
   <!-- atcdabbr_section_Uebersetzung -->
   <include href="include/1.2.40.0.34.6.0.11.2.8-2023-04-13T110152.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.8-2023-04-13T110152-closed.sch"/>
   <!-- elgagab_section_AktuelleMedikationUnkodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.9-2026-01-14T131341.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.9-2026-01-14T131341-closed.sch"/>
   <!-- atcdabbr_section_MessergebnisseKodiert -->
   <include href="include/1.2.40.0.34.6.0.11.2.95-2026-01-14T085807.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.2.95-2026-01-14T085807-closed.sch"/>
   <!-- atcdabbr_entry_SerienmessungVitalparameterEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.100-2021-01-28T145003.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.100-2021-01-28T145003-closed.sch"/>
   <!-- atcdabbr_entry_SerienmessungEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.101-2021-01-21T081221.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.101-2021-01-21T081221-closed.sch"/>
   <!-- atcdabbr_entry_SerienmessungsGruppeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.102-2021-02-19T125910.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.102-2021-02-19T125910-closed.sch"/>
   <!-- SerienmessungsWerteEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.103-2021-01-28T145841.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.103-2021-01-28T145841-closed.sch"/>
   <!-- SerienmessungsPeriodeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.104-2021-02-19T125919.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.104-2021-02-19T125919-closed.sch"/>
   <!-- atcdabrr_entry_Comment -->
   <include href="include/1.2.40.0.34.6.0.11.3.11-2021-02-19T124256.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.11-2021-02-19T124256-closed.sch"/>
   <!-- atcdabbr_entry_externalDocument -->
   <include href="include/1.2.40.0.34.6.0.11.3.14-2023-04-13T110204.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.14-2023-04-13T110204-closed.sch"/>
   <!-- atcdabbr_entry_ProblemPflegediagnosen -->
   <include href="include/1.2.40.0.34.6.0.11.3.189-2025-07-16T125932.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.189-2025-07-16T125932-closed.sch"/>
   <!-- atcdabbr_entry_EingebettetesObjektEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.19-2023-05-09T164236.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.19-2023-05-09T164236-closed.sch"/>
   <!-- atcdabbr_entry_ProblemConcernPflegediagnosen -->
   <include href="include/1.2.40.0.34.6.0.11.3.192-2026-01-07T110723.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.192-2026-01-07T110723-closed.sch"/>
   <!-- atcdabbr_entry_VitalparameterGruppeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.23-2021-02-19T130106.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.23-2021-02-19T130106-closed.sch"/>
   <!-- atcdabbr_entry_VitalparameterEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.24-2025-02-13T113313.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.24-2025-02-13T113313-closed.sch"/>
   <!-- atcdabbr_entry_CriticalityObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.35-2021-06-28T134402.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.35-2021-06-28T134402-closed.sch"/>
   <!-- atcdabbr_entry_CertaintyObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.36-2021-02-19T124249.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.36-2021-02-19T124249-closed.sch"/>
   <!-- atcdabbr_entry_SeverityObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.38-2021-02-19T130038.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.38-2021-02-19T130038-closed.sch"/>
   <!-- atcdabbr_entry_ProblemStatusObservation -->
   <include href="include/1.2.40.0.34.6.0.11.3.49-2021-02-19T125553.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.49-2021-02-19T125553-closed.sch"/>
   <!-- atcdabbr_entry_Logo -->
   <include href="include/1.2.40.0.34.6.0.11.3.53-2021-06-28T110849.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.53-2021-06-28T110849-closed.sch"/>
   <!-- atcdabbr_entry_MessergebnisseGruppeEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.70-2021-02-18T133433.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.70-2021-02-18T133433-closed.sch"/>
   <!-- atcdabbr_entry_MessergebnisEntry -->
   <include href="include/1.2.40.0.34.6.0.11.3.71-2021-02-18T133403.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.3.71-2021-02-18T133403-closed.sch"/>
   <!-- atcdabbr_other_PerformerBody -->
   <include href="include/1.2.40.0.34.6.0.11.9.17-2021-02-19T133615.sch"/>
   <include href="include/1.2.40.0.34.6.0.11.9.17-2021-02-19T133615-closed.sch"/>

</schema>
