<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.108
Name: Laboratory Specialty Section (Infektionsserologie)
Description: Die "Laboratory Specialty Section (Infektionsserologie)" entspricht jenem Befundbereich eines Mikrobiologiebefundes, in dem alle Ergebnisse der Infektionsserologie dokumentiert werden. Jedes ermittelte Ergebnis wird direkt in einer separaten "Laboratory Observation" codiert.  Darstellung der Ergebnisse  "section/text" enthält den
                narrativen Text, der der CDA Level 2 Darstellung der medizinischen Inhalte entspricht.  "section/text" darf keine medizinisch relevanten Inhalte enthalten, die nicht aus den CDA Level 3 codierten Daten abgeleitet werden können.  Die CDA Level 3 codierten Informationen sind über das Template "Laboratory Report Data Processing Entry" abzubilden, welches die Grundlage für die
                Strukturierung (Abschnitte, Formatierung, etc.) von "section/text" bildet.   Die Darstellung der Infektionsserologie in "section/text" hat tabellarisch zu erfolgen, wobei die Tabelle wie folgt aufgebaut sein sollte. Die Optionalität in dieser Tabelle bezieht s
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638">
   <title>Laboratory Specialty Section (Infektionsserologie)</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]"
         id="d45e7459-false-d986704e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']) &gt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']) &lt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']) = 0">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1'] DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:code[(@code = '722143004' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:code[(@code = '722143004' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:code[(@code = '722143004' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:code[(@code = '722143004' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &gt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &lt;= 1">(Laboratory Specialty Section (Infektionsserologie)): Element hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']"
         id="d45e7465-false-d986973e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Infektionsserologie)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.108')">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.108' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']"
         id="d45e7473-false-d986985e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Infektionsserologie)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.2.1')">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.3.3.2.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:id[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:id[not(@nullFlavor)]"
         id="d45e7486-false-d986997e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Infektionsserologie)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:code[(@code = '722143004' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:code[(@code = '722143004' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d45e7493-false-d987008e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Laboratory Specialty Section (Infektionsserologie)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="@nullFlavor or (@code='722143004' and @codeSystem='2.16.840.1.113883.6.96' and @displayName='Infectious disease diagnostic study note (record artifact)')">(Laboratory Specialty Section (Infektionsserologie)): Der Elementinhalt MUSS einer von 'code '722143004' codeSystem '2.16.840.1.113883.6.96' displayName='Infectious disease diagnostic study note (record artifact)'' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Laboratory Specialty Section (Infektionsserologie)): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:title[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:title[not(@nullFlavor)]"
         id="d45e7503-false-d987030e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Laboratory Specialty Section (Infektionsserologie)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="text()='Infektionsserologie'">(Laboratory Specialty Section (Infektionsserologie)): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Infektionsserologie'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:text[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:text[not(@nullFlavor)]"
         id="d45e7509-false-d987044e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(Laboratory Specialty Section (Infektionsserologie)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@typeCode) = ('DRIV')">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.108
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.8']]]
Item: (Laboratory Specialty Section (Infektionsserologie))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.108']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.8']]]">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.108-2021-04-06T094638.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Laboratory Specialty Section (Infektionsserologie)): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
