<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.107
Name: Laboratory Specialty Section (Molekularer Erregernachweis)
Description: Die "Laboratory Specialty Section (Molekularer Erregernachweis)" entspricht jenem Befundbereich eines Mikrobiologiebefundes, in dem alle molekularen Erregernachweise dokumentiert werden. Jeder ermittelte Erreger wird direkt in einer separaten "Laboratory Observation" codiert.  Darstellung der Ergebnisse  "section/text" enthält den
                narrativen Text, der der CDA Level 2 Darstellung der medizinischen Inhalte entspricht.  "section/text" darf keine medizinisch relevanten Inhalte enthalten, die nicht aus den CDA Level 3 codierten Daten abgeleitet werden können.  Die CDA Level 3 codierten Informationen sind über das Template "Laboratory Report Data Processing Entry" abzubilden, welches die Grundlage für die
                Strukturierung (Abschnitte, Formatierung, etc.) von "section/text" bildet.   Die Darstellung der molekularen Erregernachweise in "section/text" hat tabellarisch zu erfolgen, wobei die Tabelle wie folgt aufgebaut sein sollte. Die Optionalität in dieser Tabelle
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654">
   <title>Laboratory Specialty Section (Molekularer Erregernachweis)</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]"
         id="d45e7111-false-d914878e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']) &gt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']) &lt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']) = 0">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1'] DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:code[(@code = '108262000' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:code[(@code = '108262000' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:code[(@code = '108262000' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:code[(@code = '108262000' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &gt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &lt;= 1">(Laboratory Specialty Section (Molekularer Erregernachweis)): Element hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']"
         id="d45e7117-false-d915147e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.107')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.107' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']"
         id="d45e7125-false-d915159e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.2.1')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.3.3.2.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:id[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:id[not(@nullFlavor)]"
         id="d45e7138-false-d915171e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:code[(@code = '108262000' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:code[(@code = '108262000' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d45e7145-false-d915182e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="@nullFlavor or (@code='108262000' and @codeSystem='2.16.840.1.113883.6.96' and @displayName='Molecular biology method (procedure)')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Elementinhalt MUSS einer von 'code '108262000' codeSystem '2.16.840.1.113883.6.96' displayName='Molecular biology method (procedure)'' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Laboratory Specialty Section (Molekularer Erregernachweis)): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:title[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:title[not(@nullFlavor)]"
         id="d45e7155-false-d915204e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="text()='Molekularer Erregernachweis'">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Molekularer Erregernachweis'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:text[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:text[not(@nullFlavor)]"
         id="d45e7161-false-d915218e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@typeCode) = ('DRIV')">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.107
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.8']]]
Item: (Laboratory Specialty Section (Molekularer Erregernachweis))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.107']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.8']]]">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251112T130945/tmp-1.2.40.0.34.6.0.11.2.107-2021-04-06T085654.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Laboratory Specialty Section (Molekularer Erregernachweis)): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
